## ----setup, echo=FALSE---------------------------------------------------
library(UseBioconductor)
stopifnot(BiocInstaller::biocVersion() == "3.1")

## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()

## ------------------------------------------------------------------------
x = rnorm(1000)
y = x + rnorm(sd=.5, 1000)

## ------------------------------------------------------------------------
rnorms = lapply(0:3, function(mean) {
   rnorm(1000, mean)
})
rnorms = lapply(0:3, rnorm, n=1000, mean=0)

## ------------------------------------------------------------------------
m = matrix(1:6, 2)
dput(m)

## ------------------------------------------------------------------------
acctFactory = function() {
  balance <- 0
  list(deposit=function(amt) {
    balance <<- balance + amt
  }, currBalance=function() {
    balance
  })
}

## ------------------------------------------------------------------------
x = rnorm(1000)
y = x + rnorm(sd=.5, 1000)
df = data.frame(X=x, Y=y)

## ------------------------------------------------------------------------
fit = lm(Y ~ X, df)
plot(Y ~ X, df)
abline(fit, lwd=4, col="red")
anova(fit)

## ------------------------------------------------------------------------
suppressPackageStartupMessages({
    library(IRanges)
})
start <- as.integer(runif(1000, 1, 1e4))
width <- as.integer(runif(length(start), 50, 100))
ir <- IRanges(start, width=width)
coverage(ir)

