% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_DetectHVG_LVG.R
\name{BASiCS_DetectVG}
\alias{BASiCS_DetectVG}
\alias{BASiCS_DetectHVG}
\alias{BASiCS_DetectLVG}
\alias{BASiCS_DetectHVG_LVG}
\alias{BASiCS_DetectHVGLVG}
\title{Detection method for highly (HVG) and lowly (LVG) variable genes}
\usage{
BASiCS_DetectVG(
  Chain,
  Task = c("HVG", "LVG"),
  PercentileThreshold = NULL,
  VarThreshold = NULL,
  ProbThreshold = 2/3,
  EpsilonThreshold = NULL,
  EFDR = 0.1,
  OrderVariable = c("Prob", "GeneIndex", "GeneName"),
  Plot = FALSE,
  MinESS = 100,
  ...
)

BASiCS_DetectLVG(Chain, ...)

BASiCS_DetectHVG(Chain, ...)
}
\arguments{
\item{Chain}{an object of class \code{\linkS4class{BASiCS_Chain}}}

\item{Task}{Search for highly variable genes (\code{Task="HVG"})
or lowly variable genes (\code{Task="LVG"}).}

\item{PercentileThreshold}{Threshold to detect a percentile of variable genes
(must be a positive value, between 0 and 1). 
Default: \code{PercentileThreshold = NULL}.}

\item{VarThreshold}{Variance contribution threshold
(must be a positive value, between 0 and 1). This is only used when the 
BASiCS non-regression model was used to generate the Chain object.
Default: \code{VarThreshold = NULL}.}

\item{ProbThreshold}{Optional parameter. Posterior probability threshold
(must be a positive value, between 0 and 1). If \code{EFDR = NULL}, the 
posterior probability threshold for the test will be set to
\code{ProbThreshold}.}

\item{EpsilonThreshold}{Threshold for residual overdispersion above which}

\item{EFDR}{Target for expected false discovery rate related
to HVG/LVG detection. If \code{EFDR = NULL}, EFDR calibration is
not performed and the posterior probability threshold is set equal to
\code{ProbThreshold}. Default \code{EFDR = 0.10}.}

\item{OrderVariable}{Ordering variable for output.
Possible values: \code{'GeneIndex'}, \code{'GeneName'} and \code{'Prob'}.
Default \code{ProbThreshold = 'Prob'}}

\item{Plot}{If \code{Plot = TRUE} error control and
expression versus HVG/LVG probability plots are generated.}

\item{MinESS}{The minimum effective sample size for a gene to be included 
in the HVG or LVG tests. This helps to remove genes with poor mixing from
detection of HVGs/LVGs.
Default is 100. If set to NA, genes are
not checked for effective sample size the tests are performed.}

\item{...}{Graphical parameters (see \code{\link[graphics]{par}}).}
}
\value{
An object of class \code{\link[BASiCS]{BASiCS_ResultVG}}.
}
\description{
Functions to detect highly and lowly variable genes. If the 
BASiCS_Chain object was generated using the regression approach,
BASiCS finds the top highly variable genes based on the posteriors of the 
epsilon parameters. Otherwise, the old approach is used, which initially 
performs a variance decomposition.
}
\details{
In some cases, the EFDR calibration step may fail to find probability
threshold that controls the EFDR at the chosen level. In cases like

See vignette
}
\examples{

# Loads short example chain (non-regression implementation)
data(ChainSC)

# Highly and lowly variable genes detection (within a single group of cells)
DetectHVG <- BASiCS_DetectHVG(ChainSC, VarThreshold = 0.60,
                              EFDR = 0.10, Plot = TRUE)
DetectLVG <- BASiCS_DetectLVG(ChainSC, VarThreshold = 0.40,
                              EFDR = 0.10, Plot = TRUE)
                              
# Loads short example chain (regression implementation)
data(ChainSCReg)

# Highly and lowly variable genes detection (within a single group of cells)
DetectHVG <- BASiCS_DetectHVG(ChainSCReg, PercentileThreshold = 0.90,
                              EFDR = 0.10, Plot = TRUE)
DetectLVG <- BASiCS_DetectLVG(ChainSCReg, PercentileThreshold = 0.10,
                              EFDR = 0.10, Plot = TRUE)

## Highly and lowly variable genes detection based on residual overdispersion
## threshold
DetectHVG <- BASiCS_DetectHVG(ChainSCReg, EpsilonThreshold = log(2), Plot = TRUE)
DetectLVG <- BASiCS_DetectLVG(ChainSCReg, EpsilonThreshold = -log(2), Plot = TRUE)

}
\references{
Vallejos, Marioni and Richardson (2015). PLoS Computational Biology.
}
\seealso{
\code{\linkS4class{BASiCS_Chain}}
}
\author{
Catalina A. Vallejos \email{cnvallej@uc.cl}

Nils Eling \email{eling@ebi.ac.uk}
}
