% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\docType{methods}
\name{subset}
\alias{subset}
\alias{subset,BASiCS_Chain-method}
\title{A 'subset' method for `BASiCS_Chain`` objects}
\usage{
\S4method{subset}{BASiCS_Chain}(x, Genes = NULL, Cells = NULL, Iterations = NULL)
}
\arguments{
\item{x}{A \code{\linkS4class{BASiCS_Chain}} object.}

\item{Genes, Cells}{A vector of characters, logical values, or numbers, indicating
which cells or genes will be extracted.}

\item{Iterations}{Numeric vector of positive integers indicating which MCMC
iterations will be extracted. The maximum value in \code{Iterations} must be
less or equal than the total number of iterations contained in the original
\code{\linkS4class{BASiCS_Chain}} object.}
}
\value{
An object of class \code{\linkS4class{BASiCS_Chain}}.
}
\description{
This can be used to extract a subset of a `BASiCS_Chain` object.
The subset can contain specific genes, cells or MCMC iterations
}
\examples{

data(ChainSC)

# Extracts 3 first genes
ChainSC1 <- subset(ChainSC, Genes = rownames(ChainSC)[1:3])
# Extracts 3 first cells
ChainSC2 <- subset(ChainSC, Cells = colnames(ChainSC)[1:3])
# Extracts 10 first iterations
ChainSC3 <- subset(ChainSC, Iterations = 1:10)

}
\author{
Catalina A. Vallejos \email{cnvallej@uc.cl}
}
