% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_DiagPlot.R
\name{BASiCS_DiagPlot}
\alias{BASiCS_DiagPlot}
\alias{BASiCS_diagPlot}
\title{Create diagnostic plots of MCMC parameters}
\usage{
BASiCS_DiagPlot(
  object,
  Parameter = "mu",
  Measure = c("ess", "geweke.diag", "rhat"),
  x = NULL,
  y = NULL,
  LogX = isTRUE(x \%in\% c("mu", "delta")),
  LogY = isTRUE(y \%in\% c("mu", "delta")),
  Smooth = TRUE,
  HLine = TRUE,
  na.rm = TRUE
)

BASiCS_diagPlot(...)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{BASiCS_Summary}}}

\item{Parameter}{Name of the parameter to be plotted.
Default \code{Parameter = 'mu'}}

\item{Measure}{Character scalar specifying the diagnostic measure to plot.
Current options are effective sample size, the Geweke diagnostic
criterion, and the \code{\link[posterior]{rhat}} diagnostic.}

\item{x, y}{Optional MCMC parameter values to be plotted on the x or y axis,
respectively. If neither is supplied, Parameter will be plotted on the x axis
and effective sample size will be plotted on the y axis as
a density plot.}

\item{LogX, LogY}{A logical value indicating whether to use a log10
transformation for the x or y axis, respectively.}

\item{Smooth}{A logical value indicating whether to use smoothing
(specifically hexagonal binning using \code{\link[ggplot2]{geom_hex}}).}

\item{HLine}{Numeric scalar or vector indicating threshold value(s) to be
displayed as a dashed line on the plot when \code{DrawHLine = TRUE}.
Alternatively, can be set to \code{FALSE} to disable line drawing,
or \code{TRUE} to use the default thresholds.}

\item{na.rm}{Logical value indicating whether NA values should be removed
before calculating effective sample size.}

\item{...}{Unused.}
}
\value{
A ggplot object.
}
\description{
Plot parameter values and effective sample size.
See \link[coda]{effectiveSize}
for more details on this diagnostic measure.
}
\examples{

# Built-in example chain
data(ChainSC)

# Point estimates versus effective sample size
BASiCS_DiagPlot(ChainSC, Parameter = "mu")
# Effective sample size as colour, mu as x, delta as y.
BASiCS_DiagPlot(ChainSC, x = "mu", y = "delta")

# Point estimates versus Geweke diagnostic
BASiCS_DiagPlot(ChainSC, Parameter = "mu", Measure = "geweke.diag")

}
\seealso{
\code{\linkS4class{BASiCS_Chain}}
}
\author{
Alan O'Callaghan
}
