% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAnnotation.R
\name{getAnnotation}
\alias{getAnnotation}
\title{Retrieve Bgee experiments annotation for targeted species and data type.}
\usage{
getAnnotation(myBgeeObject)
}
\arguments{
\item{myBgeeObject}{A Reference Class Bgee object, notably specifying the targeted species and data type.}
}
\value{
A list of two elements, including a data frame of the annotation of experiments for chosen species (field "experiment.annotation") and a data frame of the annotation of chips/libraries from these experiments (field "sample.annotation").
}
\description{
This function loads the annotation of experiments and samples of quantitative expression datasets (rna_seq, affymetrix, sc_full_length, sc_droplet_based) that are available from Bgee.
}
\examples{
{
  bgee <- Bgee$new(species = "Mus_musculus", dataType = "rna_seq")
  myAnnotation <- getAnnotation(bgee)
}

}
\author{
Andrea Komljenovic and Julien Roux.
}
