% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topAnat.R
\name{topAnat}
\alias{topAnat}
\title{Produces an object allowing to perform GO-like enrichment of anatomical terms using the topGO package}
\usage{
topAnat(topAnatData, geneList, nodeSize = 10, ...)
}
\arguments{
\item{topAnatData}{a list including a gene2anatomy list, an organ.relationships list and an organ.names data.frame, produced by the function loadTopAnatData().}

\item{geneList}{Vector indicating foreground and background genes. Names of the vector indicate the background genes. Values are 1 (gene in foreground) or 0 (gene not in foreground).}

\item{nodeSize}{Minimum number of genes mapped to a node for it to be tested. Default is 10.}

\item{...}{Additional parameters as passed to build topGOdata object in topGO package.}
}
\value{
topAnatObject, a topAnatData class object, ready for gene set enrichment testing with topGO.
}
\description{
This function produces a topAnatObject, ready to use for gene set enrichment testing using functions from the topGO package. This object uses the Uberon ontology instead of the GO ontology.
}
\details{
To perform the enrichment test for expression in anatomical structures for each term of Uberon ontology (browsable at \url{http://www.ontobee.org/ontology/UBERON}), the data are formatted to use the topGO package for testing. This package is interesting because it propagates the mapping of gene to terms to parent terms, and it possesses a pannel of enrichment tests and decorrelation methods. Expert users should be able to use information from the topAnatObject to test enrichment with other packages than topGO.
}
\examples{
{
bgee <- Bgee$new(species="Bos_taurus", dataType="rna_seq")
myTopAnatData <- loadTopAnatData(bgee, stage="UBERON:0000092")
geneList <- as.factor(c(rep(0, times=85), rep(1, times=15)))
names(geneList) <- c("ENSBTAG00000000011","ENSBTAG00000000014","ENSBTAG00000000016",
                     "ENSBTAG00000000026","ENSBTAG00000000039","ENSBTAG00000000040",
                     "ENSBTAG00000000042","ENSBTAG00000000050","ENSBTAG00000000056",
                     "ENSBTAG00000000064","ENSBTAG00000000067","ENSBTAG00000000071",
                     "ENSBTAG00000000072","ENSBTAG00000000080","ENSBTAG00000000081",
                     "ENSBTAG00000000084","ENSBTAG00000000091","ENSBTAG00000000099",
                     "ENSBTAG00000000111","ENSBTAG00000000123","ENSBTAG00000000132",
                     "ENSBTAG00000000153","ENSBTAG00000000162","ENSBTAG00000000163",
                     "ENSBTAG00000000169","ENSBTAG00000000179","ENSBTAG00000000197",
                     "ENSBTAG00000000199","ENSBTAG00000000202","ENSBTAG00000000203",
                     "ENSBTAG00000000204","ENSBTAG00000000213","ENSBTAG00000000215",
                     "ENSBTAG00000000223","ENSBTAG00000000224","ENSBTAG00000000225",
                     "ENSBTAG00000000236","ENSBTAG00000000250","ENSBTAG00000000251",
                     "ENSBTAG00000000252","ENSBTAG00000000253","ENSBTAG00000000261",
                     "ENSBTAG00000000274","ENSBTAG00000000277","ENSBTAG00000000279",
                     "ENSBTAG00000000285","ENSBTAG00000000286","ENSBTAG00000000287",
                     "ENSBTAG00000000289","ENSBTAG00000000297","ENSBTAG00000000305",
                     "ENSBTAG00000000312","ENSBTAG00000000328","ENSBTAG00000000335",
                     "ENSBTAG00000000341","ENSBTAG00000000343","ENSBTAG00000000354",
                     "ENSBTAG00000000355","ENSBTAG00000000356","ENSBTAG00000000365",
                     "ENSBTAG00000000372","ENSBTAG00000000379","ENSBTAG00000000380",
                     "ENSBTAG00000000382","ENSBTAG00000000396","ENSBTAG00000000404",
                     "ENSBTAG00000000405","ENSBTAG00000000406","ENSBTAG00000000411",
                     "ENSBTAG00000000425","ENSBTAG00000000434","ENSBTAG00000000435",
                     "ENSBTAG00000000438","ENSBTAG00000000448","ENSBTAG00000000451",
                     "ENSBTAG00000000454","ENSBTAG00000000456","ENSBTAG00000000457",
                     "ENSBTAG00000000459","ENSBTAG00000000462","ENSBTAG00000000469",
                     "ENSBTAG00000000470","ENSBTAG00000000484","ENSBTAG00000000497",
                     "ENSBTAG00000000501","ENSBTAG00000009707","ENSBTAG00000026266",
                     "ENSBTAG00000021992","ENSBTAG00000005353","ENSBTAG00000005333",
                     "ENSBTAG00000006424","ENSBTAG00000026972","ENSBTAG00000010799",
                     "ENSBTAG00000010799","ENSBTAG00000014614","ENSBTAG00000014614",
                     "ENSBTAG00000045757","ENSBTAG00000046332","ENSBTAG00000046332",
                     "ENSBTAG00000008394")
myTopAnatObject <-  topAnat(myTopAnatData, geneList)
}

}
\author{
Julien Roux
}
