% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_overlaps.R
\name{generateOverlaps}
\alias{generateOverlaps}
\title{Generate overlaps of cell sets for input genes}
\usage{
generateOverlaps(geneSetExp, percentile = 90, pairs = NULL)
}
\arguments{
\item{geneSetExp}{A gene expression non-sparse matrix with the rows
restricted to the genes for which cell sets will be computed.}

\item{percentile}{A positive number under 100.}

\item{pairs}{Pairs of cell sets to be assessed. If \code{NULL} (as default),
all pairs will be assessed.}
}
\value{
A data frame listing statistics for all cell set overlaps
}
\description{
This function constructs, for each gene in the expression matrix, a set of
cells expressing the gene at or above the input percentile.
Subsequently, overlaps of pairs of the constructed cell sets are assessed
for statistical significance.
}
\details{
Wrapper around \code{percentileSets} and \code{cellSetsOverlaps}.
}
\examples{
mat <- matrix(0, 2000, 500)
rownames(mat) <- paste0('G', seq(2000))
colnames(mat) <- paste0('C', seq(500))
mat[sample(length(mat), 270000)] <- sample(50, 270000, TRUE)
mat <- mat[paste0('G', sample(2000, 5)), ]
generateOverlaps(mat)

}
