% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{TransformParams}
\alias{TransformParams}
\alias{TransformParams-class}
\alias{TransformParams,ANY-method}
\alias{TransformParams,character-method}
\alias{show,TransformParams-method}
\title{Parameters for Data Transformation}
\description{
Collects and checks necessary parameters required for transformation within CV.
}
\section{Constructor}{

\describe{
\item{\code{TransformParams(transform, characteristics = DataFrame(), intermediate = character(0), ...)}}{ 
Creates a \code{TransformParams} object which stores the function which will do the
transformation and parameters that the function will use.
\describe{
\item{\code{transform}}{A character keyword referring to a registered transformation function. See \code{\link{available}}
for valid keywords.}
\item{\code{characteristics}}{A \code{\link{DataFrame}} describing the
characteristics of data transformation to be done. First column must be
named \code{"charateristic"} and second column must be named \code{"value"}.
If using wrapper functions for data transformation in this package, the data
transformation name will automatically be generated and therefore it is not
necessary to specify it.}
\item{\code{intermediate}}{Character vector. Names of any variables created in
prior stages by \code{\link{runTest}} that need to be passed to a feature selection
function.}
\item{\code{...}}{Other named parameters which will be used by the transformation function.}
} } }
}

\section{Summary}{

\describe{
\item{\code{transformParams} is a \code{TransformParams} object.}{
    \code{show(transformParams)}: Prints a short summary of what \code{transformParams} contains.
 }}
}

\examples{

  transformParams <- TransformParams("diffLoc", location = "median")
  # Subtract all values from training set median, to obtain absolute deviations.

}
\author{
Dario Strbenac
}
