% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DuplexTrack.R
\name{show,DuplexTrack-method}
\alias{show,DuplexTrack-method}
\title{Show method for DuplexTrack}
\usage{
\S4method{show}{DuplexTrack}(object)
}
\arguments{
\item{object}{DuplexTrack.}
}
\value{
class representation
}
\description{
Show method for DuplexTrack
}
\examples{
library(InteractionSet)
anchor1 <- GRanges(
    seqnames = "chr1",
    ranges = IRanges(
        start = c(100, 600, 1100, 1600, 2100),
        end = c(200, 700, 1200, 1700, 2200)
    ),
    strand = "+"
)
anchor2 <- GRanges(
    seqnames = "chr1",
    ranges = IRanges(
        start = c(300, 800, 1300, 1800, 2300),
        end = c(400, 900, 1400, 1900, 2400)
    ),
    strand = "+"
)

interactions <- GInteractions(anchor1, anchor2, mode = "strict")
gr_region <- range(anchor1, anchor2)
a <- DuplexTrack(interactions, gr_region = gr_region, stacking = "dense")
show(a)
}
