% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_classification.R
\name{getChimericJunctionTypes}
\alias{getChimericJunctionTypes}
\title{Classify chimeric junctions of two-arm reads into types}
\usage{
getChimericJunctionTypes(gi, normal_gap_threshold = 10)
}
\arguments{
\item{gi}{\code{GInteractions} object}

\item{normal_gap_threshold}{minimum allowed distance between chimeric arms}
}
\value{
gi object of the same size with the 'junction_type' field added
}
\description{
Chimeric reads which can be represented ans two-arm interactions can be
divided into several categories based on the distance between the chimeric
fragments and existence of the overlap between these fragments.
}
\details{
Takes \code{GInteractions} object and classifies junctions into following categories
\describe{
\item{2arm}{ normal chimeric read }
\item{2arm_short}{ normal chimeric read with junction < \emph{normal_gap_threshold}}
\item{self_ovl}{ arms overlap}
\item{antisense_ovl}{ arms overlap on the opposite strand}
}
}
\examples{
data("RNADuplexesSampleData")
preproc_df <- runDuplexDiscoPreproc(RNADuplexesRawBed, table_type = "bedpe")
preproc_gi <- makeGiFromDf(preproc_df)
preproc_gi <- getChimericJunctionTypes(preproc_gi)
table(preproc_gi$junction_type)
}
