% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-io.R
\name{ImportQiime2}
\alias{ImportQiime2}
\alias{import_qiime2}
\alias{mp_import_qiime2}
\title{Import function to load the output of qiime2.}
\usage{
import_qiime2(
  otuqza,
  taxaqza = NULL,
  mapfilename = NULL,
  refseqqza = NULL,
  treeqza = NULL,
  parallel = FALSE,
  ...
)

mp_import_qiime2(
  otuqza,
  taxaqza = NULL,
  mapfilename = NULL,
  refseqqza = NULL,
  treeqza = NULL,
  parallel = FALSE,
  ...
)
}
\arguments{
\item{otuqza}{character, the file contained otu table, the ouput of qiime2.}

\item{taxaqza}{character, the file contained taxonomy, the ouput of qiime2,
default is NULL.}

\item{mapfilename}{character, the file contained sample information,
the tsv format, default is NULL.}

\item{refseqqza}{character, the file contained reference sequences or the XStringSet object,
default is NULL.}

\item{treeqza}{character, the file contained the tree file or treedata object, which is the result 
parsed by functions of treeio, default is NULL.}

\item{parallel}{logical, whether parsing the column of taxonomy multi-parallel, default is FALSE.}

\item{..., }{additional parameters.}
}
\value{
MPSE-class or phyloseq-class contained the argument class.
}
\description{
The function was designed to import the output of qiime2 and convert them to phyloseq
class.
}
\examples{
otuqzafile <- system.file("extdata", "table.qza",
                          package="MicrobiotaProcess")
taxaqzafile <- system.file("extdata", "taxa.qza",
                           package="MicrobiotaProcess")
mapfile <- system.file("extdata", "metadata_qza.txt",
                       package="MicrobiotaProcess")
mpse <- mp_import_qiime2(otuqza=otuqzafile, taxaqza=taxaqzafile,
                         mapfilename=mapfile)
mpse
}
\author{
Shuangbin Xu
}
