% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-io.R
\name{build_tree}
\alias{build_tree}
\alias{build_tree,DNAStringSet-method}
\alias{build_tree,DNAStringSet}
\alias{build_tree,DNAbin-method}
\alias{build_tree,DNAbin}
\alias{build_tree,character-method}
\alias{build_tree,character}
\title{building tree}
\usage{
build_tree(seqs, ...)

\S4method{build_tree}{DNAStringSet}(seqs, ...)

\S4method{build_tree}{DNAbin}(seqs, ...)

\S4method{build_tree}{character}(seqs, ...)
}
\arguments{
\item{seqs}{DNAStringSet or DNAbin, the object of R.}

\item{..., }{additional parameters, see also \code{\link[DECIPHER]{AlignSeqs}}.}
}
\value{
the phylo class of tree.
}
\description{
The function can be used to building tree.
}
\examples{
\dontrun{
    seqtabfile <- system.file("extdata", "seqtab.nochim.rds", 
                              package="MicrobiotaProcess")
    seqtab <- readRDS(seqtabfile)
    refseq <- colnames(seqtab)
    names(refseq) <- paste0("OTU_",seq_len(length(refseq)))
    refseq <- Biostrings::DNAStringSet(refseq)
    tree <- build_tree(refseq)
    or
    tree <- build_tree(refseq) 
}
}
\author{
Shuangbin Xu
}
