% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-generalizedFC.R
\name{generalizedFC}
\alias{generalizedFC}
\alias{generalizedFC.default}
\alias{generalizedFC.formula}
\title{generalized fold change}
\usage{
generalizedFC(x, ...)

\method{generalizedFC}{default}(x, y, base = 10, steps = 0.05, pseudo = 1e-05, ...)

\method{generalizedFC}{formula}(x, data, subset, na.action, ...)
}
\arguments{
\item{x}{numeric vector, numeric vector of data values or
formula, example 'Ozone ~ Month', Ozone is a numeric variable
giving the data values ‘Month’ a factor giving the corresponding groups.}

\item{...}{additional arguments.}

\item{y}{numeric vector, numeric vector of data values}

\item{base}{a positive or complex number, the base with respect to 
which logarithms are computed, default is 10.}

\item{steps}{positive numeric, increment of the sequence, 
default is 0.05.}

\item{pseudo}{positive numeric, avoid the zero for logarithmic, 
default is 0.00001.}

\item{data}{data.frame, an optional matrix or data frame,containing the 
variables in the formula.}

\item{subset}{(similar: see 'wilcox.test')an optional vector specifying 
a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when the 
data, contain 'NA's. Defaults to 'getOption("na.action")'.}
}
\value{
list contained gfc, the mean and median of different group.
}
\description{
calculate the mean difference in a set of predefined 
quantiles of the logarithmic
}
\examples{
set.seed(1024)
data <- data.frame(A=rnorm(1:10,mean=5), 
                   B=rnorm(2:11, mean=6), 
                   group=c(rep("case",5),rep("control",5))) 
generalizedFC(B ~ group,data=data)
generalizedFC(x=c(1,2,3,4,5),y=c(3,4,5,6,7))
}
\author{
Shuangbin Xu
}
