% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-ggclust.R
\name{ggclust}
\alias{ggclust}
\alias{ggclust.treedata}
\title{plot the result of hierarchical cluster analysis for the samples}
\usage{
ggclust(obj, ...)

\method{ggclust}{treedata}(
  obj,
  layout = "rectangular",
  factorNames = NULL,
  factorLevels = NULL,
  pointsize = 2,
  fontsize = 2.6,
  hjust = -0.1,
  ...
)
}
\arguments{
\item{obj}{R object, treedata object.}

\item{..., }{additional params, see also \code{\link[ggtree]{geom_tippoint}}}

\item{layout}{character, the layout of tree, see also \code{\link[ggtree]{ggtree}}.}

\item{factorNames}{character, default is NULL.}

\item{factorLevels}{list, default is NULL.}

\item{pointsize}{numeric, the size of point, default is 2.}

\item{fontsize}{numeric, the size of text of tiplabel, default is 2.6.}

\item{hjust}{numeric, default is -0.1}
}
\value{
the figures of hierarchical cluster.
}
\description{
plot the result of hierarchical cluster analysis for the samples
}
\examples{
\dontrun{
library(phyloseq)
library(ggtree)
library(ggplot2)
data(GlobalPatterns)
subGlobal <- subset_samples(GlobalPatterns,
         SampleType \%in\% c("Feces", "Mock", "Ocean", "Skin"))
hcsample <- get_clust(subGlobal, distmethod="jaccard",
                  method="hellinger", hclustmethod="average")
hc_p <- ggclust(hcsample, layout = "rectangular",
                pointsize=1, fontsize=0,
                factorNames=c("SampleType")) +
        theme_tree2(legend.position="right",
                    plot.title = element_text(face="bold", lineheight=25,hjust=0.5))
}
}
\author{
Shuangbin Xu
}
