% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-ggordpoint.R
\name{ggordpoint}
\alias{ggordpoint}
\alias{ggordpoint.default}
\alias{ggordpoint.pcasample}
\title{ordination plotter based on ggplot2.}
\usage{
ggordpoint(obj, ...)

\method{ggordpoint}{default}(
  obj,
  pc = c(1, 2),
  mapping = NULL,
  sampleda = NULL,
  factorNames = NULL,
  factorLevels = NULL,
  poinsize = 2,
  linesize = 0.3,
  arrowsize = 1.5,
  arrowlinecolour = "grey",
  ellipse = FALSE,
  showsample = FALSE,
  ellipse_pro = 0.9,
  ellipse_alpha = 0.2,
  ellipse_linewd = 0.5,
  ellipse_lty = 3,
  biplot = FALSE,
  topn = 5,
  settheme = TRUE,
  speciesannot = FALSE,
  fontsize = 2.5,
  labelfactor = NULL,
  stroke = 0.1,
  fontface = "bold.italic",
  fontfamily = "sans",
  textlinesize = 0.02,
  ...
)

\method{ggordpoint}{pcasample}(obj, ...)
}
\arguments{
\item{obj}{prcomp class or pcasample class,}

\item{...}{additional parameters, see \code{\link[ggrepel]{geom_text_repel}}.}

\item{pc}{integer vector, the component index.}

\item{mapping}{set of aesthetic mapping of ggplot2, default is NULL
when your want to set it by yourself, only alpha can be setted, and
the first element of factorNames has been setted to map 'fill', and
the second element of factorNames has been setted to map 'starshape',
you can add 'scale_starshape_manual' of 'ggstar' to set the shapes.}

\item{sampleda}{data.frame, nrow sample * ncol factors, default is NULL.}

\item{factorNames}{vector, the names of factors contained sampleda.}

\item{factorLevels}{list, the levels of the factors, default is NULL,
if you want to order the levels of factor, you can set this.}

\item{poinsize}{numeric, the size of point, default is 2.}

\item{linesize}{numeric, the line size of segment, default is 0.3.}

\item{arrowsize}{numeric, the size of arrow, default is 1.5.}

\item{arrowlinecolour}{character, the color of segment, default is grey.}

\item{ellipse}{logical, whether add confidence ellipse to ordinary plot, default is FALSE.}

\item{showsample}{logical, whether show the labels of sample, default is FALSE.}

\item{ellipse_pro}{numeric, confidence value for the ellipse, default is 0.9.}

\item{ellipse_alpha}{numeric, the alpha of ellipse, default is 0.2.}

\item{ellipse_linewd}{numeric, the width of ellipse line, default is 0.5.}

\item{ellipse_lty}{integer, the type of ellipse line, default is 3}

\item{biplot}{logical, whether plot the species, default is FALSE.}

\item{topn}{integer or vector, the number species have top important contribution, default is 5.}

\item{settheme}{logical, whether set the theme for the plot, default is TRUE.}

\item{speciesannot}{logical, whether plot the species, default is FALSE.}

\item{fontsize}{numeric, the size of text, default is 2.5.}

\item{labelfactor}{character, the factor want to be show in label, default is NULL.}

\item{stroke}{numeric, the line size of points, default is 0.1.}

\item{fontface}{character, the font face, default is "blod.italic".}

\item{fontfamily}{character, the font family, default is "sans".}

\item{textlinesize}{numeric, the segment size in \code{\link[ggrepel]{geom_text_repel}}.}
}
\value{
point figures of PCA or PCoA.
}
\description{
ordination plotter based on ggplot2.
}
\examples{
\dontrun{
library(phyloseq)
data(GlobalPatterns)
subGlobal <- subset_samples(GlobalPatterns,
         SampleType \%in\% c("Feces", "Mock", "Ocean", "Skin"))
pcares <- get_pca(subGlobal, method="hellinger")
pcaplot <- ggordpoint(pcares, biplot=TRUE,
                    speciesannot=TRUE,
                     factorNames=c("SampleType"), ellipse=TRUE)
}
}
\author{
Shuangbin Xu
}
