% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_pd_metric.R
\name{mp_cal_pd_metric}
\alias{mp_cal_pd_metric}
\alias{mp_cal_pd_metric,MPSE-method}
\alias{mp_cal_pd_metric,MPSE}
\alias{mp_cal_pd_metric,tbl_mpse-method}
\alias{mp_cal_pd_metric,tbl_mpse}
\alias{mp_cal_pd_metric,grouped_df_mpse-method}
\alias{mp_cal_pd_metric,grouped_df_mpse}
\title{Calculating related phylogenetic alpha metric with MPSE or tbl_mpse object}
\usage{
mp_cal_pd_metric(
  .data,
  .abundance,
  action = "add",
  metric = c("PAE", "NRI", "NTI", "PD", "HAED", "EAED", "all"),
  abundance.weighted = FALSE,
  force = FALSE,
  seed = 123,
  ...
)

\S4method{mp_cal_pd_metric}{MPSE}(
  .data,
  .abundance,
  action = "add",
  metric = c("PAE", "NRI", "NTI", "PD", "HAED", "EAED", "IAC", "all"),
  abundance.weighted = FALSE,
  force = FALSE,
  seed = 123,
  ...
)

\S4method{mp_cal_pd_metric}{tbl_mpse}(
  .data,
  .abundance,
  action = "add",
  metric = c("PAE", "NRI", "NTI", "PD", "HAED", "EAED", "all"),
  abundance.weighted = TRUE,
  force = FALSE,
  seed = 123,
  ...
)

\S4method{mp_cal_pd_metric}{grouped_df_mpse}(
  .data,
  .abundance,
  action = "add",
  metric = c("PAE", "NRI", "NTI", "PD", "HAED", "EAED", "all"),
  abundance.weighted = TRUE,
  force = FALSE,
  seed = 123,
  ...
)
}
\arguments{
\item{.data}{object, MPSE or tbl_mpse object}

\item{.abundance}{The column name of OTU abundance column to be calculate.}

\item{action}{character it has three options, "add" joins the new information
to the input tbl (default), "only" return a non-redundant tibble with the just
new information, ang 'get' return a 'alphasample' object.}

\item{metric}{the related phylogenetic metric, options is 'NRI', 'NTI', 'PD', 'PAE', 'HAED', 'EAED', 'IAC', 'all',
default is 'PAE', 'all' meaning all the metrics ('NRI', 'NTI', 'PD', 'PAE', 'HAED', 'EAED', 'IAC').}

\item{abundance.weighted}{logical, whether calculate mean nearest taxon distances for each species
weighted by species abundance, default is TRUE.}

\item{force}{logical whether calculate the alpha index even the '.abundance' is
not rarefied, default is FALSE.}

\item{seed}{integer a random seed to make the result reproducible, default is 123.}

\item{...}{additional arguments see also "ses.mpd" and "ses.mntd" of "picante".}
}
\value{
update object.
}
\description{
Calculating related phylogenetic alpha metric with MPSE or tbl_mpse object
}
\examples{
\dontrun{
  suppressPackageStartupMessages(library(curatedMetagenomicData))
  xx <- curatedMetagenomicData('ZellerG_2014.relative_abundance', dryrun=F)
  xx[[1]] \%>\% as.mpse -> mpse
  mpse \%<>\% 
    mp_cal_pd_metric(
      .abundance = Abundance, 
      force = TRUE,
      metric = 'PAE'
    )
  mpse \%>\% 
    mp_plot_alpha(
      .alpha = PAE,
      .group = disease
  )
}
}
\references{
Cadotte, M.W., Jonathan Davies, T., Regetz, J., Kembel, S.W., Cleland,
E. and Oakley, T.H. (2010), Phylogenetic diversity metrics for ecological communities:
integrating species richness, abundance and evolutionary history. Ecology Letters,
13: 96-105. https://doi.org/10.1111/j.1461-0248.2009.01405.x.

Webb, C. O. (2000). Exploring the phylogenetic structure of ecological communities: 
an example for rain forest trees. The American Naturalist, 156(2), 145-155.
https://doi.org/10.1086/303378.
}
\author{
Shuangbin Xu
}
