% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-Groups.R
\name{CyGroups}
\alias{CyGroups}
\alias{createCyGroups}
\title{Cytoscape Groups}
\usage{
createCyGroups(
  id = NULL,
  name,
  nodes = NULL,
  externalEdges = NULL,
  internalEdges = NULL,
  collapsed = NULL
)
}
\arguments{
\item{id}{integer (optional); Cytoscape group ids}

\item{name}{character; names of the groups}

\item{nodes}{list of integers (optional); reference to \link[=Nodes]{node ids}}

\item{externalEdges}{list of integers (optional); the external edges making up the group; reference to \link[=Edges]{edge ids}}

\item{internalEdges}{list of integers (optional); the internal edges making up the group; reference to \link[=Edges]{edge ids}}

\item{collapsed}{logical (optional); whether the group is displayed as a single node}
}
\value{
\emph{CyGroupsAspect} object
}
\description{
This function is used to create Cytoscape "groups" aspects.
}
\details{
Cytoscape contributes aspects that organize subnetworks, attribute tables, and visual attributes for use by its own layout and
analysis tools. Furthermore are the aspects used in web-based visualizations like within the NDEx platform.

Cytoscape groups allow to group a set of \code{\link{Nodes}} and corresponding internal and external \code{\link{Edges}} together,
and represent a group as a single node in the visualization.
A group is defined by its unique id, which must be an (positive) integer, which serves as reference to other aspects.
If no ids are provided, they are created automatically.
}
\examples{
## a minimal example
cyGroups = createCyGroups(
  name = "Group One",
  nodes = list(c(1,2,3)),
  internalEdges = list(c(0,1))
)

## defining several groups at once
cyGroups = createCyGroups(
  name = c("Group One", "Group Two"),
  nodes = list(c(1,2,3), 0),
  internalEdges = list(c(0,1),NA)
)

## with all parameters
cyGroups = createCyGroups(
  id = c(0,1),
  name = c("Group One", "Group Two"),
  nodes = list(c(1,2,3), 0),
  internalEdges = list(c(0,1),NA),
  externalEdges = list(NA,c(1,3)),
  collapsed = c(TRUE,NA)                     
)

}
\seealso{
\code{\link{updateCyGroups}};
}
