% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-VisualProperties.R
\name{CyVisualPropertyProperties}
\alias{CyVisualPropertyProperties}
\alias{createCyVisualPropertyProperties}
\title{Create a object for properties of Cytoscape Visual Properties (object used in CyVisualProperty)}
\usage{
createCyVisualPropertyProperties(value, name = NULL)
}
\arguments{
\item{value}{character or named character; value of the property}

\item{name}{character (optional); name of the property}
}
\value{
CyVisualPropertyProperties object
}
\description{
This function is used to create aspects for mappings in \link[=CyVisualProperties]{Cytoscape visual properties}.
Networks, nodes, edges, and default nodes and edges mappings are realized as \code{\link{CyVisualProperty}} objects, that each consist of
properties (\strong{this here}), dependencies (\code{\link{CyVisualPropertyDependencies}} objects) and mappings (\code{\link{CyVisualPropertyMappings}} objects).
}
\details{
Cytoscape contributes aspects that organize subnetworks, attribute tables, and visual attributes for use by its own layout and
analysis tools. Furthermore are the aspects used in web-based visualizations like within the NDEx platform.

The visual properties aspect is the only aspect (\code{\link{CyVisualProperties}}) with a complex structure. It is composed of several sub-property classes and
consists of \code{\link{CyVisualProperty}} objects, that belong to, or more precisely describe one of the following network elements:
\emph{network}, \emph{nodes}, \emph{edges}, \emph{defaultNodes} or \emph{defaultEdges}.

A single visual property (i.e. \code{\link{CyVisualProperty}} object) organizes the information as \emph{properties}, \emph{dependencies} and \emph{mappings},
as well as the single values \emph{appliesTo} and \emph{view}, that define the subnetwork or view to which the IDs apply.

Properties are \code{\link{CyVisualPropertyProperties}} objects, that hold information like
\code{"NODE_FILL_COLOR" : "#26CCC9"} or \code{"NODE_LABEL_TRANSPARENCY" : "255"} in a key-value like manner.

Dependencies are \code{\link{CyVisualPropertyDependencies}} objects, that hold information
about dependencies between visual properties.
Currently there are only three dependencies supported:
\itemize{
\item Lock Node with and height: \code{nodeSizeLocked = "false"}
\item Fit Custom Graphics to node: \code{nodeCustomGraphicsSizeSync = "true"}
\item Edge color to arrows: \code{arrowColorMatchesEdge = "false"}
}

Mappings are \code{\link{CyVisualPropertyMappings}} objects, that hold information as a triplet consisting of name, type and definition, like
\code{"NODE_FILL_COLOR" : "DISCRETE" : "COL=molecule_type,T=string,K=0=miRNA,V=0=#FCEC00"},
\verb{"NODE_FILL_COLOR" : "CONTINUOUS" : "COL=gal1RGexp,T=double...} or
\code{"NODE_LABEL" : "PASSTHROUGH" : "COL=COMMON,T=string"}.

For further information about Cytoscape visual properties see the \code{Styles} topic of the official Cytoscape documentation:
\href{http://manual.cytoscape.org/en/stable/Styles.html}{http://manual.cytoscape.org/en/stable/Styles.html}

\subsection{Structure of Cytoscape Visual Properties}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{CyVisualProperties
|---network = CyVisualProperty
|---nodes = CyVisualProperty
|---edges = CyVisualProperty
|---defaultNodes = CyVisualProperty
|---defaultEdges = CyVisualProperty

CyVisualProperty
|---properties = CyVisualPropertyProperties
|   |--name
|   |--value 
|---dependencies = CyVisualPropertyDependencies
|   |--name
|   |--value 
|---mappings = CyVisualPropertyMappings
|   |--name
|   |--type
|   |--definition 
|---appliesTo = <reference to subnetwork id>
|---view = <reference to subnetwork id>
}\if{html}{\out{</div>}}
}
}
\note{
If \emph{name} is not provided, the \emph{names(value)} is used instead to infer the names.
}
\examples{
## Using a named vector
vpPropertyNamedValue = c(NODE_BORDER_STROKE="SOLID", 
                         NODE_BORDER_WIDTH="1.5")
createCyVisualPropertyProperties(vpPropertyNamedValue)

## Using two separate vectors
vpPropertyName = c("NODE_BORDER_STROKE", 
                   "NODE_BORDER_WIDTH")
vpPropertyValue = c("SOLID", 
                    "1.5")
createCyVisualPropertyProperties(vpPropertyValue, 
                                 vpPropertyName)

# Result for either:
#                 name value
# 1 NODE_BORDER_STROKE SOLID
# 2  NODE_BORDER_WIDTH   1.5
}
\seealso{
\code{\link{updateCyVisualProperty}}, \code{\link{updateCyVisualProperties}}
}
