% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-VisualProperties.R
\name{getCyVisualProperty}
\alias{getCyVisualProperty}
\title{Get a Cytoscape visual property (object used in CyVisualProperties aspect) by appliesTo and view}
\usage{
getCyVisualProperty(cyVisualProperty, appliesTo = NA, view = NA)
}
\arguments{
\item{cyVisualProperty}{\code{\link{CyVisualProperty}} object}

\item{appliesTo}{integer (optional); value of appliesTo to filter for}

\item{view}{integer (optional); value of view to filter for}
}
\value{
\code{\link{CyVisualProperty}} object containing only one element, or \code{NULL}
}
\description{
This function helps filtering \code{\link{CyVisualProperty}} objects by appliesTo and view attributes (i.e. a unique combination of both).
If nothing matches the searched pattern \code{NULL} is returned.
}
\details{
Cytoscape contributes aspects that organize subnetworks, attribute tables, and visual attributes for use by its own layout and
analysis tools. Furthermore are the aspects used in web-based visualizations like within the NDEx platform.

The visual properties aspect is the only aspect (\code{\link{CyVisualProperties}}) with a complex structure. It is composed of several sub-property classes and
consists of \code{\link{CyVisualProperty}} objects, that belong to, or more precisely describe one of the following network elements:
\emph{network}, \emph{nodes}, \emph{edges}, \emph{defaultNodes} or \emph{defaultEdges}.

A single visual property (i.e. \code{\link{CyVisualProperty}} object) organizes the information as \emph{properties}, \emph{dependencies} and \emph{mappings},
as well as the single values \emph{appliesTo} and \emph{view}, that define the subnetwork or view to which the IDs apply.

Properties are \code{\link{CyVisualPropertyProperties}} objects, that hold information like
\code{"NODE_FILL_COLOR" : "#26CCC9"} or \code{"NODE_LABEL_TRANSPARENCY" : "255"} in a key-value like manner.

Dependencies are \code{\link{CyVisualPropertyDependencies}} objects, that hold information
about dependencies between visual properties.
Currently there are only three dependencies supported:
\itemize{
\item Lock Node with and height: \code{nodeSizeLocked = "false"}
\item Fit Custom Graphics to node: \code{nodeCustomGraphicsSizeSync = "true"}
\item Edge color to arrows: \code{arrowColorMatchesEdge = "false"}
}

Mappings are \code{\link{CyVisualPropertyMappings}} objects, that hold information as a triplet consisting of name, type and definition, like
\code{"NODE_FILL_COLOR" : "DISCRETE" : "COL=molecule_type,T=string,K=0=miRNA,V=0=#FCEC00"},
\verb{"NODE_FILL_COLOR" : "CONTINUOUS" : "COL=gal1RGexp,T=double...} or
\code{"NODE_LABEL" : "PASSTHROUGH" : "COL=COMMON,T=string"}.

For further information about Cytoscape visual properties see the \code{Styles} topic of the official Cytoscape documentation:
\href{http://manual.cytoscape.org/en/stable/Styles.html}{http://manual.cytoscape.org/en/stable/Styles.html}

\subsection{Structure of Cytoscape Visual Properties}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{CyVisualProperties
|---network = CyVisualProperty
|---nodes = CyVisualProperty
|---edges = CyVisualProperty
|---defaultNodes = CyVisualProperty
|---defaultEdges = CyVisualProperty

CyVisualProperty
|---properties = CyVisualPropertyProperties
|   |--name
|   |--value 
|---dependencies = CyVisualPropertyDependencies
|   |--name
|   |--value 
|---mappings = CyVisualPropertyMappings
|   |--name
|   |--type
|   |--definition 
|---appliesTo = <reference to subnetwork id>
|---view = <reference to subnetwork id>
}\if{html}{\out{</div>}}
}
}
\examples{
## Visual property: Properties
vpPropertyP1 = createCyVisualPropertyProperties(c(NODE_BORDER_STROKE="SOLID"))

## Visual property: Dependencies
vpPropertyD1 = createCyVisualPropertyDependencies(c(nodeSizeLocked="false"))

## Visual property: Mappings
vpPropertyM1 = createCyVisualPropertyMappings(c(NODE_FILL_COLOR="CONTINUOUS"), 
                                              "COL=directed,T=boolean,K=0=true,V=0=ARROW")

## Create visual property object 
vpProperty = createCyVisualProperty(properties=list(vpPropertyP1,
                                                    vpPropertyP1,
                                                    vpPropertyP1), 
                                    dependencies=list(vpPropertyD1,
                                                      vpPropertyD1,
                                                      NA), 
                                    mappings=list(vpPropertyM1,
                                                  NA,
                                                  vpPropertyM1),
                                    appliesTo = c(NA,
                                                  NA,
                                                  1),
                                    view = c(NA,
                                             1,
                                             1))

## Get VP for no subnetwork an no view
getCyVisualProperty(vpProperty)

getCyVisualProperty(vpProperty, 
                    appliesTo = 1,
                    view = 1)
}
\seealso{
\code{\link{updateCyVisualProperty}}, \code{\link{updateCyVisualProperties}}
}
