% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-NodesAndEdges.R
\name{Edges}
\alias{Edges}
\alias{createEdges}
\title{Edges}
\usage{
createEdges(id = NULL, source, target, interaction = NULL)
}
\arguments{
\item{id}{integer (optional); edge IDs}

\item{source}{integer; reference to \link[=Nodes]{node id}}

\item{target}{integer; reference to \link[=Nodes]{node id}}

\item{interaction}{character (optional); type of interaction, eg. "binds" or "activates"}
}
\value{
\emph{EdgesAspect} object
}
\description{
This function creates edges between nodes in networks.
}
\details{
Edges are represented by \emph{EdgesAspect} objects.
Edges connect two nodes, which means that \emph{source} and \emph{target} must reference the IDs of nodes in a \code{\link{Nodes}} object.
On creation, the IDs don't matter yet, but at least while adding the \emph{EdgesAspect} object to an \code{\link{RCX-object}},
the \emph{IDs} must be present in the nodes aspect of the \code{\link{RCX-object}}.

Similar to nodes, an edge also has a unique \emph{id}, which must be an (positive) integer, which serves as reference to other aspects.
If no IDs are provided, those are assigned automatically.
Optionally, edges can have an interaction attribute to define the type of interaction between the nodes.
}
\examples{
## create some simple edges
edges1 = createEdges(source=1, target=2)

## create edges with more information
edges2 = createEdges(id=c(3,2,4),
                    source=c(0,0,1), 
                    target=c(1,2,2),
                    interaction=c("activates","inhibits", NA))
}
\seealso{
\code{\link{updateEdges}} for adding a \emph{EdgesAspect} object to an \emph{EdgesAspect} or \emph{RCX} object
}
