% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Print.R
\name{custom-print}
\alias{custom-print}
\alias{print.MetaDataAspect}
\alias{print.NodesAspect}
\alias{print.EdgesAspect}
\alias{print.NodeAttributesAspect}
\alias{print.EdgeAttributesAspect}
\alias{print.NetworkAttributesAspect}
\alias{print.CartesianLayoutAspect}
\alias{print.CyGroupsAspect}
\alias{print.CyVisualPropertyProperties}
\alias{print.CyVisualPropertyDependencies}
\alias{print.CyVisualPropertyMappings}
\alias{print.CyVisualProperty}
\alias{print.CyVisualPropertiesAspect}
\alias{print.CyHiddenAttributesAspect}
\alias{print.CyNetworkRelationsAspect}
\alias{print.CySubNetworksAspect}
\alias{print.CyTableColumnAspect}
\alias{print.RCX}
\title{Print functions for RCX and aspect classes}
\usage{
\method{print}{MetaDataAspect}(x, ...)

\method{print}{NodesAspect}(x, ...)

\method{print}{EdgesAspect}(x, ...)

\method{print}{NodeAttributesAspect}(x, ...)

\method{print}{EdgeAttributesAspect}(x, ...)

\method{print}{NetworkAttributesAspect}(x, ...)

\method{print}{CartesianLayoutAspect}(x, ...)

\method{print}{CyGroupsAspect}(x, ...)

\method{print}{CyVisualPropertyProperties}(x, ...)

\method{print}{CyVisualPropertyDependencies}(x, ...)

\method{print}{CyVisualPropertyMappings}(x, ...)

\method{print}{CyVisualProperty}(x, fields = c("all"), ...)

\method{print}{CyVisualPropertiesAspect}(x, propertyOf = "all", fields = "all", ...)

\method{print}{CyHiddenAttributesAspect}(x, ...)

\method{print}{CyNetworkRelationsAspect}(x, ...)

\method{print}{CySubNetworksAspect}(x, ...)

\method{print}{CyTableColumnAspect}(x, ...)

\method{print}{RCX}(x, inofficial = TRUE, ...)
}
\arguments{
\item{x}{aspect or \link[=RCX-object]{RCX} object}

\item{...}{further arguments passed to or from other methods. See \code{\link[base:print]{base::print()}}}

\item{fields}{character; Which fields should be shown, one of properties, dependencies, mappings or \code{all}}

\item{propertyOf}{character; Which properties should be shown, one of network, nodes, edges, nodes:default, edges:default or \code{all}}

\item{inofficial}{logical; if \code{FALSE} only the official aspects are printed}
}
\value{
prints the object and returns it invisibly (\href{x}{invisible})
}
\description{
These functions attempt to print \link[=RCX-object]{RCX} and aspect objects in a more readable form.
}
\examples{
rcx = createRCX(createNodes())
print(rcx)
}
\seealso{
\link{summary}
}
