% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFLOMICS-Methods_00_Common.R
\name{generateReport}
\alias{generateReport}
\alias{generateReport,RflomicsMAE-method}
\title{Generate RFLOMICS html report or archive}
\usage{
\S4method{generateReport}{RflomicsMAE}(
  object,
  reportName = NULL,
  archiveName = NULL,
  tmpDir = NULL,
  ...
)
}
\arguments{
\item{object}{a object of \link{RflomicsSE} class or
\link{RflomicsMAE-class} class.}

\item{reportName}{Name of the html report.}

\item{archiveName}{Name of archive with all analysis results}

\item{tmpDir}{temporary directory (default: working directory)}

\item{...}{other arguments to pass into the render function.}
}
\value{
An html report or archive (tar.gz)
}
\description{
This function is used to generate a html report from a
\link{RflomicsMAE-class} object or archive with results.
}
\examples{
library(RFLOMICS)
# load ecoseed data
data(ecoseed.mae)

factorInfo <- data.frame(
  "factorName"   = c("Repeat", "temperature", "imbibition"),
  "factorType"   = c("batch", "Bio", "Bio")
)

# create rflomicsMAE object with ecoseed data
MAE <- createRflomicsMAE(
  projectName = "Tests",
  omicsData   = ecoseed.mae,
  omicsTypes  = c("RNAseq","proteomics","metabolomics"),
  factorInfo  = factorInfo)

formulae <- generateModelFormulae(MAE)
MAE <- setModelFormula(MAE, modelFormula = formulae[[1]])

selectedContrasts <-
  generateExpressionContrast(MAE, contrastType="simple")

MAE <- setSelectedContrasts(MAE, contrastList = selectedContrasts)

## data processing
MAE <- runDataProcessing(
  object = MAE,
  SE.name = "protetest",
  samples=NULL,
  normMethod="none",
  transformMethod="none")

## diff analysis
MAE <- runDiffAnalysis(
  object = MAE,
  SE.name = "protetest",
  contrastList =
    selectedContrasts,
  p.adj.method="BH",
  method = "limmalmFit",
  p.adj.cutoff = 0.05,
  logFC.cutoff = 0)

## Enrichment
# MAE <- runAnnotationEnrichment(
#   object = MAE,
#   SE.name = "protetest",
#   database = "GO",
#   domain = c("MF"),
#   list_args = list(OrgDb = "org.At.tair.db",
#                    keyType = "TAIR",
#                    pvalueCutoff = 0.05))

# get name of performed analysis
getAnalyzedDatasetNames(MAE)

# generate report
#generateReport(object = MAE, reportName = "ecoseed_report.html")
}
