% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFLOMICS-Methods_02_set_stat_model.R
\name{generateModelFormulae}
\alias{generateModelFormulae}
\alias{generateModelFormulae,RflomicsMAE-method}
\alias{setModelFormula}
\alias{setModelFormula,RflomicsMAE-method}
\alias{setModelFormula,RflomicsSE-method}
\alias{getModelFormula}
\alias{getModelFormula,RflomicsMAE-method}
\alias{getModelFormula,RflomicsSE-method}
\title{Statistical model formulae}
\usage{
\S4method{generateModelFormulae}{RflomicsMAE}(object)

\S4method{setModelFormula}{RflomicsMAE}(object, modelFormula = NULL)

\S4method{setModelFormula}{RflomicsSE}(object, modelFormula = NULL)

\S4method{getModelFormula}{RflomicsMAE}(object)

\S4method{getModelFormula}{RflomicsSE}(object)
}
\arguments{
\item{object}{an object of class \link{RflomicsSE} or 
class \link{RflomicsMAE-class}}

\item{modelFormula}{a string of model formula generated by 
\link{generateModelFormulae}}
}
\value{
a named list of object of class formula

an object of \link{RflomicsSE} class or \link{RflomicsMAE-class}
 class
}
\description{
These methods allow the user to select and set the formula of 
the statistical method.
\itemize{
   \item generateModelFormulae():
 From a vector of character giving the name of the factors of an omics
 experiment, and their type of effect: biological or batch, it returns all 
 models formulae that can be formulated in association with this factors. 
 Batch effect factors do not appear in interaction terms with biological 
 factor. Model formulae stop in second order interaction.}

\itemize{
   \item setModelFormula():
   Set the model formula stored in \code{metadata} slot}

\itemize{
   \item getModelFormula:
 Access to the model formula of the statistical analysis}
}
\examples{
library(RFLOMICS)

# load ecoseed data
data(ecoseed.mae)

factorInfo <- data.frame(
  "factorName"   = c("Repeat", "temperature", "imbibition"),
  "factorType"   = c("batch", "Bio", "Bio")
)

# create rflomicsMAE object with ecoseed data
MAE <- RFLOMICS::createRflomicsMAE(
  projectName = "Tests",
  omicsData   = ecoseed.mae,
  omicsTypes  = c("RNAseq","proteomics","metabolomics"),
  factorInfo  = factorInfo)

# generate all statistical model formulae
formulae <- generateModelFormulae(MAE)

# chose and set model formula to rflomicsMAE object
MAE <- setModelFormula(MAE, formulae[[1]])

# Generate expression of contrasts from chosen model
contrastList <- generateExpressionContrast(MAE, "averaged")

# Set the contrasts List and choose the first 3 contrasts of type averaged
MAE <- setSelectedContrasts(MAE, contrastList = contrastList[c(1,2,3),])

}
