% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoGSEA.R
\name{DoGSEA}
\alias{DoGSEA}
\title{Perform GSEA analysis for cross-regional DE genes}
\usage{
DoGSEA(considerRes, whichDB = "hallmark", gmtdir = NULL, withProp = FALSE)
}
\arguments{
\item{considerRes}{A list of cross-regional DE genes.}

\item{whichDB}{A character string to select the database names, e.g., "hallmark", "kegg", "reactome".}

\item{gmtdir}{Directory for external database gmt file location.}

\item{withProp}{Whether deconvolution proportion is used in previous steps.}
}
\value{
A list including GSEA results for all cell types.
}
\description{
Perform GSEA analysis for cross-regional DE genes
}
\examples{
data(exampleRes)
allCTres <- DoGSEA(exampleRes, whichDB = "hallmark", withProp = TRUE)

}
