% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\docType{class}
\name{ExtImage}
\alias{ExtImage}
\alias{ExtImage-class}
\alias{show,ExtImage-method}
\title{Use the EBImage \code{Image} class in SFE objects}
\usage{
\S4method{show}{ExtImage}(object)

ExtImage(img, ext = NULL)
}
\arguments{
\item{object}{An \code{ExtImage} object.}

\item{img}{An \code{Image} object or anything that inherits from \code{Image}
such as \code{AnnotatedImage} in \code{RBioFormats}.}

\item{ext}{Numeric vector with names "xmin", "xmax", "ymin", "ymax" in
microns indicating the spatial extent covered by the image. If \code{NULL},
then the extent will be inferred from the metadata, from physical pixel
size and the number of pixels.}
}
\value{
An \code{ExtImage} object.
}
\description{
This is a thin wrapper around the \code{\link[EBImage]{Image}} class in the
\code{EBImage} package so it inherits from \code{VirtualSpatialImage} to be
compatible with \code{SpatialExperiment} from which SFE inherits. An
\code{ext} field is added to specify the spatial extent of the image in
microns to facilitate geometric operations on the SFE object (including the
images) and plotting with \code{Voyager}.
}
\concept{Image classes}
