% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{cropImg}
\alias{cropImg}
\alias{cropImg,SpatRasterImage-method}
\alias{cropImg,BioFormatsImage-method}
\alias{cropImg,ExtImage-method}
\title{Crop images}
\usage{
\S4method{cropImg}{SpatRasterImage}(x, bbox, filename = "")

\S4method{cropImg}{BioFormatsImage}(x, bbox)

\S4method{cropImg}{ExtImage}(x, bbox)
}
\arguments{
\item{x}{An object of class \code{*Image} as implemented in this package.}

\item{bbox}{Numeric vector with names "xmin", "xmax", "ymin", "ymax", in any
order, to specify the bounding box.}

\item{filename}{Output file name for transformed SpatRaster.}
}
\value{
Image of the same class as input but cropped. For
  \code{BioFormatsImage}, the image is not loaded into memory; only the
  extent is changed.
}
\description{
Crop images of class \code{*Image} in this package with a bounding box.
}
\seealso{
Other image methods: 
\code{\link{SFE-image}},
\code{\link{affineImg}()},
\code{\link{dim,BioFormatsImage-method}},
\code{\link{dim,ExtImage-method}},
\code{\link{ext}()},
\code{\link{imgRaster}()},
\code{\link{imgSource}()},
\code{\link{mirrorImg}()},
\code{\link{rotateImg}()},
\code{\link{scaleImg}()},
\code{\link{translateImg}()},
\code{\link{transposeImg}()}
}
\concept{Image methods}
\concept{image methods}
