% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveRDS.R
\name{saveRDS,SpatialFeatureExperiment-method}
\alias{saveRDS,SpatialFeatureExperiment-method}
\title{Save SpatialFeatureExperiment as RDS file}
\usage{
\S4method{saveRDS}{SpatialFeatureExperiment}(
  object,
  file = "",
  ascii = FALSE,
  version = NULL,
  compress = TRUE,
  refhook = NULL
)
}
\arguments{
\item{object}{A \code{SpatialFeatureExperiment} object.}

\item{file}{a \link[base]{connection} or the path name of the file where the
    \R object is saved to or read from.}

\item{ascii}{a logical.  If \code{TRUE} or \code{NA}, an ASCII
    representation is written; otherwise (default), a binary one is used.
    See the comments in the help for \code{\link[base]{save}}.}

\item{version}{the workspace format version to use.  \code{NULL}
    specifies the current default version (3).  The only other supported
    value is 2, the default from \R 1.4.0 to \R 3.5.0.}

\item{compress}{a logical specifying whether saving to a named file is
    to use \code{"gzip"} compression, or one of \code{"gzip"},
    \code{"bzip2"}, \code{"xz"} or \code{"zstd"} to indicate the type of
    compression to be used.  Ignored if \code{file} is a connection.}

\item{refhook}{a hook function for handling reference objects.}
}
\value{
Invisibly \code{NULL}.
}
\description{
Saving SFE objects as RDS files is complicated by the \code{SpatRaster} class
of the images. If present, the images need to be wrapped with the \code{\link[terra]{wrap}}
function in \code{terra} before serializing the SFE object. Otherwise the
images will be invalid pointers when the RDS is reloaded. If the image does
not fit in memory and its file source is unknown, then it will be written to
a temporary file, which is reloaded when the RDS file is loaded. When an SFE
object with images is read from an RDS file, the images will not be unwrapped
until necessary.
}
\examples{
outdir <- system.file("extdata", package = "SpatialFeatureExperiment")
samples <- file.path(outdir, paste0("sample0", 1:2))
sfe <- read10xVisiumSFE(samples, type = "sparse", data = "filtered")
saveRDS(sfe, "foo.rds")
# Clean up
file.remove("foo.rds")
}
\concept{Utilities}
