% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{toSpatRasterImage}
\alias{toSpatRasterImage}
\alias{toSpatRasterImage,ExtImage-method}
\alias{toSpatRasterImage,BioFormatsImage-method}
\title{Convert images to SpatRasterImage}
\usage{
\S4method{toSpatRasterImage}{ExtImage}(
  x,
  save_geotiff = TRUE,
  file_out = "img.tiff",
  overwrite = FALSE
)

\S4method{toSpatRasterImage}{BioFormatsImage}(
  x,
  save_geotiff = TRUE,
  resolution = 4L,
  channel = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{x}{Either a \code{BioFormatsImage} or \code{EBIImage} object.}

\item{save_geotiff}{Logical, whether to save the image to GeoTIFF file.}

\item{file_out}{File to save the non-OME TIFF file for \code{SpatRaster}.}

\item{overwrite}{Logical, whether to overwrite existing file of the same
name.}

\item{resolution}{Integer, which resolution in the \code{BioFormatsImage} to
read and convert. Defaults to 4, which is a lower resolution. Ignored if
only 1 resolution is present.}

\item{channel}{Integer vector to indicate channel(s) to read. If \code{NULL},
then all channels will be read.}
}
\value{
A \code{SpatRasterImage} object
}
\description{
The resolution specified from the OME-TIFF file will be read into memory and
written to disk as a GeoTIFF file that has the extent. The output file will
have the same file name as the input file except without the \code{ome} in
the extension.
}
\seealso{
toExtImage
}
\concept{Image classes}
