% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxVisiumHD-class.R
\docType{class}
\name{TENxVisiumHD-class}
\alias{TENxVisiumHD-class}
\alias{.TENxVisiumHD}
\alias{TENxVisiumHD}
\alias{import,TENxVisiumHD,ANY,ANY-method}
\title{A class to represent and import multiple Visium HD samples}
\usage{
TENxVisiumHD(
  resources,
  spatialResource,
  spacerangerOut,
  segmented_outputs,
  sample_id = "sample01",
  processing = c("filtered", "raw"),
  format = c("mtx", "h5"),
  images = c("lowres", "hires", "detected", "aligned_fiducials"),
  bin_size = c("008", "016", "002"),
  jsonFile = .SCALE_JSON_FILE,
  tissuePattern = "tissue_positions\\\\.parquet",
  spatialCoordsNames = c("pxl_col_in_fullres", "pxl_row_in_fullres"),
  ...
)

\S4method{import}{TENxVisiumHD,ANY,ANY}(con, format, text, ...)
}
\arguments{
\item{resources}{A \link[TENxIO:TENxFileList-class]{TENxFileList} object or a
file path to the tarball containing the matrix / assay data resources.}

\item{spatialResource}{A \link[=TENxSpatialList-class]{TENxSpatialList}
object or a file path to the tarball containing the spatial data.}

\item{spacerangerOut}{\code{character(1)} A single string specifying the path to
the sample directory of \verb{spaceranger count}. The directory must contain the
\verb{(processing)_feature_bc_matrix} and \code{spatial} sub directories in addition
to the \code{outs} folder.}

\item{segmented_outputs}{\code{character(1)} The path to the \code{segmented_outputs}
directory}

\item{sample_id}{\code{character(1)} A single string specifying the sample ID.}

\item{processing}{\code{character(1)} A single string indicating the processing
folder available e.g., "filtered_feature_barcode_matrix" in the
\code{spacerangerOut} folder. It can be either "filtered" or "raw" (default
"filtered"). Only used when \code{spacerangerOut} is specified.}

\item{format}{The format of the output. If missing and \code{con} is a
file name, the format is derived from the file extension. This argument is
unnecessary when \code{con} is a derivative of \link[BiocIO:BiocFile-class]{BiocFile}.}

\item{images}{\code{character()} A vector specifying the images to be imported;
can be one or multiple of "lowres", "hires", "detected", "aligned".}

\item{bin_size}{\code{character(1)} The bin size of the images to import. The
default is \code{008}. It corresponds to the directory name \code{square_000um} where
\code{000} is the bin value.}

\item{jsonFile}{\code{character(1)} A single string specifying the name of the
JSON file containing the scale factors.}

\item{tissuePattern}{\code{character(1)} A single string specifying the pattern
to match the tissue positions file.}

\item{spatialCoordsNames}{\code{character()} A vector of strings specifying the
names of the columns in the spatial data containing the spatial coordinates.}

\item{...}{In the constructor, additional arguments passed to
\link[TENxIO:TENxFileList-class]{TENxFileList}; otherwise, not used.}

\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[BiocIO:BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{text}{If \code{con} is missing, this can be a character vector directly
providing the string data to import.}
}
\value{
A \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment}
object
}
\description{
This class contains a \code{SimpleList} of \link{TENxVisiumHD} objects
each corresponding to one sample. The provided \code{spacerangerOut} folder
should contain a \code{binned_outputs} folder where multiple \code{bin_size}
subfolders are present, e.g., \code{square_002um}.
}
\details{
Typically, the user will provide a path to a directory containing
the output of the \verb{spaceranger count} command. The \verb{spaceranger count}
command outputs a folder containing the "raw" or "filtered"
\verb{()_feature_bc_matrix}.
}
\section{Functions}{
\itemize{
\item \code{import(con = TENxVisiumHD, format = ANY, text = ANY)}: Import Visium HD data from multiple bin sizes

}}
\examples{

vdir <- system.file(
    "extdata", package = "VisiumIO", mustWork = TRUE
)

## with spacerangerOut folder
TENxVisiumHD(spacerangerOut = vdir, bin_size = "002", images = "lowres")

TENxVisiumHD(spacerangerOut = vdir, bin_size = "002", images = "lowres") |>
    import()

## indicate h5 format
TENxVisiumHD(
    spacerangerOut = vdir, bin_size = "002",
    images = "lowres", format = "h5"
)

TENxVisiumHD(
    spacerangerOut = vdir, bin_size = "002",
    images = "lowres", format = "h5"
) |>
    import()

## use resources and spatialResource arguments as file paths
TENxVisiumHD(
    resources = file.path(
        vdir, "binned_outputs", "square_002um",
        "filtered_feature_bc_matrix.h5"
    ),
    spatialResource = file.path(
        vdir, "binned_outputs", "square_002um",
        "spatial"
    ),
    bin_size = "002", processing = "filtered",
    images = "lowres", format = "h5"
) |>
    import()

## provide the spatialResource argument as a TENxFileList
TENxVisiumHD(
    resources = file.path(
        vdir, "binned_outputs", "square_002um",
        "filtered_feature_bc_matrix.h5"
    ),
    spatialResource = TENxFileList(
        file.path(
            vdir, "binned_outputs", "square_002um",
            "spatial"
        )
    ),
    bin_size = "002", images = "lowres", format = "h5"
) |>
    import()

seg_outs <- system.file(
    "extdata", "segmented_outputs", package = "VisiumIO", mustWork = TRUE
)
TENxVisiumHD(
    segmented_outputs = seg_outs,
    format = "h5",
    images = "lowres"
) |>
    import()
}
\author{
E. Y. Dong, M. Ramos
}
