# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

aggregate <- function(x, f) {
    .Call(`_epigraHMM_aggregate`, x, f)
}

computeBIC <- function(hdf5, numPar, numSamples) {
    .Call(`_epigraHMM_computeBIC`, hdf5, numPar, numSamples)
}

computeQFunction <- function(hdf5, pi, gamma) {
    .Call(`_epigraHMM_computeQFunction`, hdf5, pi, gamma)
}

computeViterbiSequence <- function(hdf5, pi, gamma) {
    .Call(`_epigraHMM_computeViterbiSequence`, hdf5, pi, gamma)
}

consensusRejectionControlled <- function(hdf5, f, p) {
    .Call(`_epigraHMM_consensusRejectionControlled`, hdf5, f, p)
}

differentialRejectionControlled <- function(hdf5, f, p, N) {
    .Call(`_epigraHMM_differentialRejectionControlled`, hdf5, f, p, N)
}

#' E-step of HMM (forward-backward probability + posterior probability calculation)
#' @param pi a vector of probabilities (sum of probabilities should sum to one)
#' @param gamma a matrix of transition probabilities (row sums should be one)
#' @param logf a matrix of observed log-likelihood values. Columns represent
#' hidden states, rows represent genomic regions
#' @param hdf5 path to where the hdf5 is saved
#'
#' @examples
#' #Creating dummy object
#' countData <- rbind(matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1),
#'                   matrix(rnbinom(2e3,mu = 7.5,size = 5),ncol = 1),
#'                   matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1))
#'
#'
#'
#' colData <- data.frame(condition = 'A', replicate = 1)
#' object <- epigraHMMDataSetFromMatrix(countData,colData)
#'
#' #Initializing
#' object <- initializer(object,controlEM())
#'
#' #Running epigraHMM
#' object <- epigraHMM(object,controlEM(),type = 'consensus',dist = 'nb')
#'
#' #Example
#' expStep(pi = c(0.99,0.02),
#'        gamma = matrix(c(0.99,0.01,0.01,0.99),nrow = 2),
#'        logf = cbind(dnbinom(rnbinom(100,mu = 2,size = 10),mu = 2,size = 10,log = TRUE),
#'                     dnbinom(rnbinom(100,mu = 7.5,size = 5),mu = 7.5,size = 5,log = TRUE)),
#'        hdf5 = file.path(tempdir(),'tmp.h5'))
#' @export
expStep <- function(pi, gamma, logf, hdf5) {
    invisible(.Call(`_epigraHMM_expStep`, pi, gamma, logf, hdf5))
}

getMarginalProbability <- function(hdf5) {
    .Call(`_epigraHMM_getMarginalProbability`, hdf5)
}

innerMaxStepProb <- function(hdf5) {
    .Call(`_epigraHMM_innerMaxStepProb`, hdf5)
}

#' M-step (maximization w.r.t. initial and transition probabilities)
#' @param hdf5 path to where the hdf5 is saved
#'
#' @examples
#' #Creating dummy object
#' countData <- rbind(matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1),
#'                   matrix(rnbinom(2e3,mu = 7.5,size = 5),ncol = 1),
#'                   matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1))
#'
#'
#'
#' colData <- data.frame(condition = 'A', replicate = 1)
#' object <- epigraHMMDataSetFromMatrix(countData,colData)
#'
#' #Initializing
#' object <- initializer(object,controlEM())
#'
#' #Running epigraHMM
#' object <- epigraHMM(object,controlEM(),type = 'consensus',dist = 'nb')
#'
#' #Example
#' maxStepProb(hdf5 = S4Vectors::metadata(object)$output)
#' @export
maxStepProb <- function(hdf5) {
    .Call(`_epigraHMM_maxStepProb`, hdf5)
}

rbinomVectorized <- function(prob) {
    .Call(`_epigraHMM_rbinomVectorized`, prob)
}

reweight <- function(x, p) {
    .Call(`_epigraHMM_reweight`, x, p)
}

#' Simulates a Markov Chain of length 'n' given a matrix of transition probabilities P
#' @param P a matrix of transition probabilities (row sums should be 1)
#' @param n an integer specifying thhe length of the simulated sequence
#'
#' @examples
#' #Example
#' simulateMarkovChain(matrix(c(0.99,0.01,0.01,0.99),2,2),100)
#' @export
simulateMarkovChain <- function(P, n) {
    .Call(`_epigraHMM_simulateMarkovChain`, P, n)
}

