% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chopMC.R
\name{chopMC}
\alias{chopMC}
\title{Keep unique ranges and collapse mcols}
\usage{
chopMC(x, simplify = TRUE)
}
\arguments{
\item{x}{A GenomicRanges object}

\item{simplify}{logical(1)}
}
\value{
A GRanges object
}
\description{
Keep unique ranges by 'chopping' mcols
}
\details{
This function finds unique ranges and chops \strong{all} mcols in a manner similar
to \link[tidyr]{chop}.
Chopped columns will be returned as \code{CompressedList} columns, unless
\code{simplify = TRUE} (the default).
In this case, columns will be returned as vectors where possible.
}
\examples{
gr <- GRanges(rep(c("chr1:1-10"), 2))
gr$id <- paste0("range", seq_along(gr))
gr$gene <- "gene1"
gr
chopMC(gr)


}
