% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotPie.R
\name{plotPie}
\alias{plotPie}
\alias{plotPie,GRanges-method}
\alias{plotPie,DataFrame-method}
\alias{plotPie,data.frame-method}
\title{Draw Pie Graphs based on one or more columns}
\usage{
plotPie(object, ...)

\S4method{plotPie}{GRanges}(object, scale_by = c("n", "width"), ...)

\S4method{plotPie}{DataFrame}(object, ...)

\S4method{plotPie}{data.frame}(
  object,
  fill,
  x,
  y,
  scale_by,
  scale_factor = 1000,
  width = 0.8,
  total_geom = c("label", "text", "none"),
  total_glue = "{comma(N)}",
  total_colour = "black",
  total_fill = "white",
  total_alpha = 1,
  total_size = 3,
  min_p = 0.01,
  max_p = 1,
  cat_geom = c("label", "text", "none"),
  cat_glue = "{.data[[fill]]}\\n{comma(n, 1)}\\n({percent(p, 0.1)})",
  cat_colour = "black",
  cat_fill = "white",
  cat_size = 3,
  cat_alpha = 1,
  cat_adj = 0,
  hole_width = 0,
  ...
)
}
\arguments{
\item{object}{An object (\code{data.frame})}

\item{...}{Not used}

\item{scale_by}{Scale the counts by this column. In this case of a GRanges
object this defaults to the count (scale_by = "n") but can also be specified
as being width of each range (scale_by = "width"). If choosing width, width
will be displayed in Kb}

\item{fill}{The category/column used to fill the slices of the pie charts}

\item{x}{The second (optional) category/column to place along the x-axis}

\item{y}{The final (optional) category/column to plce along the y-axis}

\item{scale_factor}{When scaling by another column, such as width, totals
will be divided by this value, with 1000 being the default to provide output
in kb.}

\item{width}{Scale the width of all pies}

\item{total_geom}{The geom_* to use for the totals at the centre of each pie.
Setting this to 'none' will disable totals}

\item{total_glue}{\link[glue]{glue} syntax to use for the totals in the
centre of each pie. The column 'N' will produce the totals and any other
values or formatting may be added here.}

\item{total_colour, total_fill, total_alpha, total_size}{Colour, fill, alpha and
size for the main totals in the centre of each pie chart}

\item{min_p}{The minimum proportion of the total required for adding labels.
Effectively removes labels from pie charts with few members. Alternatively
when only one column is specified, categories below this will not be shown
around the edge of the plot}

\item{max_p}{only display labels for segments representing less than this
proportion of the total.}

\item{cat_geom}{The geom_* to use for category labels corresponding to each
slice of the pie. Setting this to 'none' will disable category labels}

\item{cat_glue}{\link[glue]{glue} syntax to use for the category labels
corresponding to each slice of the pie charts. The columns 'n' and 'p' can
be used to print totals and proportions for each slice.}

\item{cat_colour, cat_fill, cat_size, cat_alpha}{Colour, fill, size and alpha
for category labels}

\item{cat_adj}{Adjust category labels}

\item{hole_width}{Add a hole in the middle to turn the plot into a donut.
Values between zero and 1 work best. Only implemented for pie charts using
one value (i.e. fill)}
}
\value{
A ggplot2 object able to be customised with colour scales and themes.

Also note that the $data element of the returned object will contain the
data.frame used for plotting. The additional column \code{label_radians}
represents the mid-point of each pie slice and can be used for manually
adding labels to each pie.
Only applies when plotting across the \code{x} or \code{y} axes
}
\description{
Draw Pie Graphs based one or more data.frame columns
}
\details{
Using a \code{data.frame} as input, this function will draw pie graphs based
on one ore more columns, by simply counting the values in combination
across these columns.
One column must be selected for the fill as a bare minimum, with up to three
being possible.
Additional columns can be set for the x-axis to draw a series of pie-graphs
in a row, with a further column able to added to layout a series of pie
graphs in a grid

If only one column/category is chosen, category labels will be added around
the edge of the plot

If \code{show_total = TRUE} the overall counts for each pie graph will be added
in the centre using \link[ggplot2]{geom_label}.
Parameters for these labels are customisable
}
\examples{
set.seed(200)
df <- data.frame(
  feature = sample(
    c("Promoter", "Enhancer", "Intergenic"), 200, replace = TRUE
  ),
  TF1 = sample(c("Up", "Down", "Unchanged"), 200, replace = TRUE),
  TF2 = sample(c("Up", "Down", "Unchanged"), 200, replace = TRUE),
  w = rexp(200)
)
plotPie(df, fill = "feature", total_glue = "N = {comma(N)}")
plotPie(
  df, fill = "feature", scale_by = "w", total_geom = "none",
  cat_glue = "{percent(p)}", cat_size = 5
)
plotPie(df, fill = "feature", x = "TF1")
plotPie(
  df, fill = "feature", x = "TF1", y = "TF2", min_p = 0.02,
  total_geom = "none", cat_glue = "{n} / {N}"
 ) +
 scale_fill_viridis_d() +
 theme_bw()


## And using a GRanges object
data("ex_prom")
gr <- ex_prom
mcols(gr) <- df[seq_along(gr),]
## Show values by counts
plotPie(gr, fill = "feature", total_size = 5)
## Show values scaled by width of each range as a donut plot
plotPie(
  gr, fill = "feature", scale_by = "width", total_glue = "{round(N, 1)}kb",
  cat_glue = "{percent(p, 0.1)}", cat_size = 4, total_size = 5, hole_width = 0.2
)

}
