% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{get_platforms_by_ids}
\alias{get_platforms_by_ids}
\title{Retrieve all platforms matching a set of platform identifiers}
\usage{
get_platforms_by_ids(
  platforms = NA_character_,
  filter = NA_character_,
  taxa = NA_character_,
  offset = 0L,
  limit = 20L,
  sort = "+id",
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{platforms}{Platform numerical identifiers or platform short names.  If not
specified, all platforms will be returned instead}

\item{filter}{Filter results by matching expression. Use \code{\link{filter_properties}}
function to get a list of all available parameters. These properties can be
combined using "and" "or" clauses and may contain common operators such as "=", "<" or "in".
(e.g. "taxon.commonName = human", "taxon.commonName in (human,mouse), "id < 1000")}

\item{taxa}{A vector of taxon common names (e.g. human, mouse, rat). Providing multiple
species will return results for all species. These are appended
to the filter and equivalent to filtering for \code{taxon.commonName} property}

\item{offset}{The offset of the first retrieved result.}

\item{limit}{Defaults to 20. Limits the result to specified amount
of objects. Has a maximum value of 100. Use together with \code{offset} and
the \code{totalElements} \link[base:attributes]{attribute} in the output to
compile all data if needed.}

\item{sort}{Order results by the given property and direction. The '+' sign
indicate ascending order whereas the '-' indicate descending.}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A data table with information about the platform(s). A list if \code{raw = TRUE}. A \code{404 error} if the given identifier
does not map to any object

The fields of the output data.table are:
\itemize{
\item \code{platform.ID}: Internal identifier of the platform
\item \code{platform.shortName}: Shortname of the platform.
\item \code{platform.name}: Full name of the platform.
\item \code{platform.description}: Free text description of the platform
\item \code{platform.troubled}: Whether or not the platform was marked "troubled" by a Gemma process or a curator
\item \code{platform.experimentCount}: Number of experiments using the platform within Gemma
\item \code{platform.type}: Technology type for the platform.
\item \code{taxon.name}: Name of the species platform was made for
\item \code{taxon.scientific}: Scientific name for the taxon
\item \code{taxon.ID}: Internal identifier given to the species by Gemma
\item \code{taxon.NCBI}: NCBI ID of the taxon
\item \code{taxon.database.name}: Underlying database used in Gemma for the taxon
\item \code{taxon.database.ID}: ID of the underyling database used in Gemma for the taxon
}
}
\description{
Retrieve all platforms matching a set of platform identifiers
}
\examples{
get_platforms_by_ids("GPL1355")
get_platforms_by_ids(c("GPL1355", "GPL96"))
}
\keyword{platform}
