% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{search_annotations}
\alias{search_annotations}
\title{Search for annotation tags}
\usage{
search_annotations(
  query,
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{query}{The search query. Queries can include plain text or ontology
terms They also support conjunctions ("alpha AND beta"), disjunctions ("alpha OR beta")
grouping ("(alpha OR beta) AND gamma"), prefixing ("alpha*"), wildcard characters
("BRCA?") and fuzzy matches ("alpha~").}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A data table with annotations (annotation search result value objects)
matching the given identifiers. A list if \code{raw = TRUE}. A \code{400 error} if required parameters are missing.

The fields of the output data.table are:

\itemize{
\item \code{category.name}: Category that the annotation belongs to
\item \code{category.URI}: URI for the category.name
\item \code{value.name}: Annotation term
\item \code{value.URI}: URI for the value.name
}
}
\description{
Search for annotation tags
}
\examples{
search_annotations("traumatic")
}
\keyword{annotation}
