% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_fs.R
\name{fortify_fs}
\alias{fortify_fs}
\alias{fortify_fs.flowSet}
\alias{fortify_fs.default}
\alias{fortify_fs.flowFrame}
\alias{fortify_fs.cytoframe}
\alias{fortify_fs.GatingSetList}
\alias{fortify_fs.GatingSet}
\title{Fortify a model into flowSet object}
\usage{
fortify_fs(model, data, ...)

\method{fortify_fs}{flowSet}(model, data, ...)

\method{fortify_fs}{default}(model, data, ...)

\method{fortify_fs}{flowFrame}(model, data, ...)

\method{fortify_fs}{cytoframe}(model, data, ...)

\method{fortify_fs}{GatingSetList}(model, data, ...)

\method{fortify_fs}{GatingSet}(model, data, ...)
}
\arguments{
\item{model}{flow object(flowFrame or GatingSet) to be converted to flowSet. when it is a GatingSet, it must contain the subset information stored as  'subset' attribute.}

\item{data}{original dataset, if needed}

\item{...}{other arguments passed to methods}
}
\value{
a flowSet/ncdfFlowSet object
}
\description{
The method provides a universe interface to convert a generic R object into a flowSet useful for ggcyto
}
\examples{
data(GvHD)
fr <- GvHD[[1]]
fortify_fs(fr)

dataDir <- system.file("extdata",package="flowWorkspaceData")
gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))
attr(gs, "subset") <- "CD4"
fortify_fs(gs)
}
