% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFlowFrame.R
\name{getFlowFrame}
\alias{getFlowFrame}
\alias{getFlowFrame.flowSet}
\alias{getFlowFrame.ncdfFlowList}
\alias{getFlowFrame.GatingSetList}
\alias{getFlowFrame.GatingSet}
\alias{getFlowFrame.GatingHierarchy}
\title{extract flowFrame data structure from the given R object}
\usage{
getFlowFrame(x)
}
\arguments{
\item{x}{flowSet, ncdfFlowList, GatingSet, GatingHierarchy, or GatingSetList}
}
\value{
a flowFrame. When x is a ncdfFlowSet or GatingSet that is associated with ncdfFlowSet, the raw event data
is not read and an empty flowFrame is returned.
}
\description{
Mainly to get the channel and marker information.
}
\examples{
data(GvHD)
fs <- GvHD[1:2]
getFlowFrame(fs)# fs is a flowSet

dataDir <- system.file("extdata",package="flowWorkspaceData")
gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))
getFlowFrame(gs)# gs is a GatingSet
}
