% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc-spatial.R
\name{sc_spatial}
\alias{sc_spatial}
\alias{sc_spatial,Seurat-method}
\alias{sc_spatial,Seurat}
\alias{sc_spatial,SingleCellExperiment-method}
\alias{sc_spatial,SingleCellExperiment}
\title{sc_spatial}
\usage{
sc_spatial(
  object,
  features = NULL,
  sample.id = NULL,
  image.id = NULL,
  slot = "data",
  plot.pie = FALSE,
  pie.radius.scale = 0.3,
  image.plot = TRUE,
  image.first.operation = "rotate",
  image.rotate.degree = NULL,
  image.mirror.axis = NULL,
  remove.point = FALSE,
  mapping = NULL,
  ncol = 6,
  density = FALSE,
  grid.n = 100,
  joint = FALSE,
  joint.fun = prod,
  common.legend = TRUE,
  pointsize = 5,
  geom = sc_geom_point,
  reduction = NULL,
  dims = NULL,
  ...
)

\S4method{sc_spatial}{Seurat}(
  object,
  features = NULL,
  sample.id = NULL,
  image.id = NULL,
  slot = "data",
  plot.pie = FALSE,
  pie.radius.scale = 0.3,
  image.plot = TRUE,
  image.first.operation = "rotate",
  image.rotate.degree = NULL,
  image.mirror.axis = NULL,
  remove.point = FALSE,
  mapping = NULL,
  ncol = 6,
  density = FALSE,
  grid.n = 100,
  joint = FALSE,
  joint.fun = prod,
  common.legend = TRUE,
  pointsize = 5,
  geom = sc_geom_point,
  reduction = NULL,
  dims = NULL,
  ...
)

\S4method{sc_spatial}{SingleCellExperiment}(
  object,
  features = NULL,
  sample.id = NULL,
  image.id = NULL,
  slot = 1,
  plot.pie = FALSE,
  pie.radius.scale = 0.3,
  image.plot = TRUE,
  image.first.operation = "rotate",
  image.rotate.degree = NULL,
  image.mirror.axis = "v",
  remove.point = FALSE,
  mapping = NULL,
  ncol = 6,
  density = FALSE,
  grid.n = 100,
  joint = FALSE,
  joint.fun = prod,
  common.legend = TRUE,
  pointsize = 5,
  geom = sc_geom_point,
  reduction = NULL,
  dims = NULL,
  ...
)
}
\arguments{
\item{object}{Seurat object}

\item{features}{selected features to be visualized}

\item{sample.id}{the index name of sample id, which only
work with SingleCellExperiment or SpatialExperiment.}

\item{image.id}{the index name of image id, which only work
with SingleCellExperiment or SpatialExperiment.}

\item{slot}{if plotting a feature, which data will be used
(e.g., 'data', 'counts'), the assay name if object
is SingleCellExperiment or SpatialExperiment.}

\item{plot.pie}{logical whether plot the features with pie, default is \code{FALSE}.}

\item{pie.radius.scale}{numeric scale to the radius of pie only work with \code{plot.pie=TRUE},
default is 0.3.}

\item{image.plot}{whether to display the issue image as background.}

\item{image.first.operation}{character which the first operation to
image, 'rotate' or 'mirror', default is 'rotate'.}

\item{image.rotate.degree}{integer the degree to ratate image, default is NULL.}

\item{image.mirror.axis}{character the direction to mirror the image, default is 'h'.}

\item{remove.point}{whether to remove the spot points, it is nice
if your just view the issue image, default is FALSE.}

\item{mapping}{aesthetic mapping, default is NULL.}

\item{ncol}{integer number of facet columns if 'length(features) > 1', default is 6.}

\item{density}{whether plot the 2D weighted kernel density, default is FALSE.}

\item{grid.n}{number of grid points in the two directions to estimate 2D
weighted kernel density, default is 100.}

\item{joint}{whether joint the multiple features with \code{joint.fun},
default is FALSE.}

\item{joint.fun}{how to joint the multiple features if \code{joint = TRUE},
default is prod.}

\item{common.legend}{whether to use \code{facet_wrap} to display the multiple
\code{features}, default is TRUE.}

\item{pointsize}{the size of point, default is 5.}

\item{geom}{the layer of point, default is \code{sc_geom_point}, other option is
\code{geom_bgpoint}.}

\item{reduction, }{reduction method name, default is NULL and will use the
spatial coordinates.}

\item{dims}{selected dimensions (must be a two-length vector) that
are used in visualization, which works with \code{reduction} argument.}

\item{...}{additional parameters, see also \code{geom_scattermore2()}.
\itemize{
\item \code{bg_colour} the colour of background point, default is \code{NA}.
this character also can be set in \code{mappint}.
\item \code{gap_colour} the colour of gap background, default is \code{'white'}.
\item \code{bg_line_width} the line width of background point,
default is \code{.3}.
\item \code{gap_line_width} the gap line width of background point,
default is \code{.1}.
\item \code{alpha} the transparency of colour, default is 1.
\item \code{subset} subset the data frame which meet conditions to display.
this should be set in \code{mapping}.
}}
}
\value{
ggplot object
}
\description{
sc_spatial
}
\examples{
\dontrun{
library(STexampleData)
# create ExperimentHub instance
eh <- ExperimentHub()
# query STexampleData datasets
myfiles <- query(eh, "STexampleData")
ah_id <- myfiles$ah_id[myfiles$title == 'Visium_humanDLPFC']
spe <- myfiles[[ah_id]]
spe <- spe[, colData(spe)$in_tissue == 1]
set.seed(123)
genes <- rownames(spe) |> sample(6) 
p <- sc_spatial(spe, features = genes, 
                image.rotate.degree = -90, 
                image.mirror.axis = NULL, 
                ncol = 3)
# The features also can be specified 
# the variables from colData or reducedDims.
p1 <- sc_spatial(spe, features = 'cell_count', 
                 image.rotate.degree = -90, image.mirror.axis = NULL)
}
}
