% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc-dim-utilities.R
\name{sc_dim_sub}
\alias{sc_dim_sub}
\title{sc_dim_sub}
\usage{
sc_dim_sub(subset, .column = "ident")
}
\arguments{
\item{subset}{subset of clusters to be displayed}

\item{.column}{which column represents cluster (e.g., 'ident')}
}
\value{
update plot with only subset displayed
}
\description{
sc_dim_sub
}
\examples{
library(scuttle)
library(scater)
library(scran)
library(ggplot2)
sce <- mockSCE()
sce <- logNormCounts(sce)
clusters <- clusterCells(sce, assay.type = 'logcounts')
colLabels(sce) <- clusters
sce <- runUMAP(sce, assay.type = 'logcounts')
p1 <- sc_dim(sce, reduction = 'UMAP')
f1 <- p1 + sc_dim_sub(subset = c(1, 2), .column = 'label')
}
\seealso{
\link{sc_dim}
}
