% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{draw_genes_barplot}
\alias{draw_genes_barplot}
\title{Stacked Barplot of Low Expression Genes by Chromosome}
\usage{
draw_genes_barplot(
  object,
  chromosomes = c(seq_len(22), "X", "Y", "MT"),
  include_others = TRUE
)
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr input.}

\item{chromosomes}{(\code{character})\cr names of the chromosomes which should be displayed.}

\item{include_others}{(\code{flag})\cr option to show the chromosomes not in \code{chromosomes} as "Others".}
}
\value{
The \code{ggplot} object with the histogram.
}
\description{
This creates a barplot of chromosomes for the \link{AnyHermesData} object with the proportions of low expression genes.
}
\examples{
object <- hermes_data

# Display chromosomes 1-22, X, Y, and MT. Other chromosomes are displayed in "Others".
# To increase readability, we can have flip the coordinate axes.
draw_genes_barplot(object) + coord_flip()

# Alternatively we can also rotate the x-axis tick labels.
draw_genes_barplot(object) + theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust = 1))

# Display chromosomes 1 and 2. Other chromosomes are displayed in "Others".
draw_genes_barplot(object, chromosomes = c("1", "2"))

# Display chromosomes 1 and 2 only.
draw_genes_barplot(object, chromosomes = c("1", "2"), include_others = FALSE)
}
