% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connections.R
\docType{class}
\name{connect_biomart}
\alias{connect_biomart}
\alias{ConnectionBiomart-class}
\alias{.ConnectionBiomart}
\alias{ConnectionBiomart}
\title{Connection to \code{BioMart}}
\usage{
connect_biomart(prefix = c("ENSG", "GeneID"), version = NULL)
}
\arguments{
\item{prefix}{(\code{string})\cr gene ID prefix.}

\item{version}{(\code{string} or \code{NULL})\cr optional \code{Ensembl} version to use. If \code{NULL}
the latest available release is used.}
}
\value{
\code{\link{ConnectionBiomart}} object.
}
\description{
\code{connect_biomart()} creates a connection object of class \code{\link{ConnectionBiomart}} which contains
the \code{biomaRt} object of class \code{\link[biomaRt:Mart-class]{biomaRt::Mart}} and the prefix of the object
which is used downstream for the query.
}
\details{
This connects to the \code{Ensembl} data base of \code{BioMart} for human genes.
A specific version can be optionally chosen to ensure reproducibility of results
once a new release is available, as accessed data might then change.
}
\examples{
if (interactive()) {
  connection <- connect_biomart("ENSG")
}
}
