% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HermesData-methods.R
\name{h_has_req_annotations}
\alias{h_has_req_annotations}
\title{Predicate for Required Annotations}
\usage{
h_has_req_annotations(object, annotation_required)
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr input object.}

\item{annotation_required}{(\code{character})\cr names of required \code{\link{annotation}} columns for genes.}
}
\value{
Named logical vector with one value for each gene in \code{object}, which is \code{TRUE} if all
required annotation columns are filled, and otherwise \code{FALSE}.
}
\description{
This helper function determines for each gene in the object whether all required
annotation columns are filled.
}
\examples{
object <- hermes_data
result <- h_has_req_annotations(object, "size")
all(result)
rowData(object)$size[1] <- NA # nolint
which(!h_has_req_annotations(object, "size"))
}
\seealso{
\code{\link[=filter]{filter()}} where this is used internally.
}
