% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality.R
\name{set_tech_failure}
\alias{set_tech_failure}
\title{Set Technical Failure Flags}
\usage{
set_tech_failure(object, sample_ids)
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr input.}

\item{sample_ids}{(\code{character}) \cr sample IDs to be flagged as technical failures.}
}
\value{
\code{\link{AnyHermesData}} object with modified technical failure flags.
}
\description{
Setter function which allows the user to define a sample manually as a technical failure.
}
\examples{
# Manually flag technical failures in a `AnyHermesData` object.
object <- hermes_data
get_tech_failure(object)["06520101B0017R"]
result <- set_tech_failure(object, c("06520101B0017R", "06520047C0017R"))
get_tech_failure(result)["06520101B0017R"]
}
\seealso{
\code{\link[=add_quality_flags]{add_quality_flags()}} which automatically sets all (gene and sample) quality flags,
including these technical failure flags.
}
