% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupNhoods.R
\name{groupNhoods}
\alias{groupNhoods}
\title{Group neighbourhoods}
\usage{
groupNhoods(
  x,
  da.res,
  da.fdr = 0.1,
  overlap = 1,
  max.lfc.delta = NULL,
  merge.discord = FALSE,
  subset.nhoods = NULL,
  compute.new = FALSE,
  na.function = "na.pass",
  original.behaviour = TRUE
)
}
\arguments{
\item{x}{A \code{\linkS4class{Milo}} object containing single-cell gene expression
and neighbourhoods.}

\item{da.res}{A \code{data.frame} containing DA results, as expected from running
\code{testNhoods}.}

\item{da.fdr}{A numeric scalar that determines at what FDR neighbourhoods are declared
DA for the purposes of aggregating across concorantly DA neighbourhoods.}

\item{overlap}{A scalar integer that determines the number of cells that must
overlap between adjacent neighbourhoods for merging.}

\item{max.lfc.delta}{A scalar that determines the absolute difference in log fold change below
which neighbourhoods should not be considered adjacent. Default=NULL}

\item{merge.discord}{A logical scalar that overrides the default behaviour and allows
adjacent neighbourhoods to be merged if they have discordant log fold change signs. Using
this argument is generally discouraged, but may be useful for constructing an empirical null
group of cells, regardless of DA sign.}

\item{subset.nhoods}{A logical, integer or character vector indicating which neighbourhoods
to subset before grouping. All other neighbourhoods will be assigned NA}

\item{compute.new}{A logical scalar indicating whether to force computing a new neighbourhood
adjacency matrix if already present.}

\item{na.function}{A valid NA action function to apply, should be one of
\code{na.fail, na.omit, na.exclude, na.pass} (default='na.pass').}

\item{original.behaviour}{A logical scalar indicating whether to use the original nhood grouping
behaviour that \emph{can} give rise to nhood groups with discordant LFC. If \code{original.behaviour=FALSE}
then the more intuitive functionality that forces nhood groups to have \emph{only} concordant LFC signs.}
}
\value{
A \code{data.frame} of model results (as \code{da.res} input) with a new column storing the assigned
group label for each neighbourhood (\code{NhoodGroup} column)
}
\description{
This function groups overlapping and concordantly DA neighbourhoods, using the louvain
community detection algorithm.
}
\details{
Louvain clustering is applied to the neighbourhood graph. This graph is first modified
based on two criteria: 1) neighbourhoods share at least \code{overlap} number of cells,
and 2) the DA log fold change sign is concordant.
This behaviour can be modulated by setting \code{overlap} to be more or less stringent.
Additionally, a threshold on the log fold-changes can be set, such that \code{max.lfc.delta}
is required to retain edges between adjacent neighbourhoods. Note: adjacent neighbourhoods will
never be merged with opposite signs.
}
\author{
Emma Dann & Mike Morgan
}
