% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmm.R
\name{initializeFullZ}
\alias{initializeFullZ}
\title{Construct the full Z matrix}
\usage{
initializeFullZ(Z, cluster_levels, stand.cols = FALSE)
}
\arguments{
\item{Z}{A \code{n x c} matrix containing the numeric or character levels}

\item{cluster_levels}{A \code{list} that maps the column names of Z onto the individual levels}

\item{stand.cols}{A logical scalar that determines if Z* should be computed which is the row-centered and
scaled version of the full Z matrix}
}
\value{
\code{matrix} Fully broadcast Z matrix with one column per random effect level for all random effect variables
in the model.
}
\description{
Using a simplified version of the \code{n x c} Z matrix, with one column per variable, construct the fully broadcast
\code{n x (c*q)} binary matrix that maps each individual onto the random effect variable levels. It is not intended
for this function to be called by the user directly, but it can be useful to debug mappings between random effect
levels and input variables.
}
\details{
To make sure that matrices commute it is necessary to construct the full \code{n x c*q} matrix. This is a binary
matrix where each level of each random effect occupies a column, and the samples/observations are mapped onto
the correct levels based on the input Z.
}
\examples{
data(sim_nbglmm)
random.levels <- list("RE1"=paste("RE1", levels(as.factor(sim_nbglmm$RE1)), sep="_"),
                      "RE2"=paste("RE2", levels(as.factor(sim_nbglmm$RE2)), sep="_"))
Z <- as.matrix(data.frame("RE1"=paste("RE1", as.numeric(sim_nbglmm$RE1), sep="_"),
                          "RE2"=paste("RE2", as.numeric(sim_nbglmm$RE2), sep="_")))
fullZ <- initializeFullZ(Z, random.levels)
dim(Z)
dim(fullZ)

}
\author{
Mike Morgan & Alice Kluzer
}
