% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/milo.R
\docType{class}
\name{Milo-class}
\alias{Milo-class}
\alias{Milo}
\title{The Milo constructor}
\usage{
Milo(
  ...,
  graph = list(),
  nhoodDistances = Matrix(0L, sparse = TRUE),
  nhoods = Matrix(0L, sparse = TRUE),
  nhoodCounts = Matrix(0L, sparse = TRUE),
  nhoodIndex = list(),
  nhoodExpression = Matrix(0L, sparse = TRUE),
  .k = NULL
)
}
\arguments{
\item{...}{Arguments passed to the Milo constructor to fill the slots of the
base class. This should be either a \code{\linkS4class{SingleCellExperiment}} or
matrix of features X cells}

\item{graph}{An igraph object or list of adjacent vertices that represents
the KNN-graph}

\item{nhoodDistances}{A list containing sparse matrices of cell-to-cell distances for
cells in the same neighbourhoods, one list entry per neighbourhood.}

\item{nhoods}{A list of graph vertices, each containing the indices
of the constiuent graph vertices in the respective neighbourhood}

\item{nhoodCounts}{A matrix of neighbourhood X sample counts of the
number of cells in each neighbourhood derived from the respective samples}

\item{nhoodIndex}{A list of cells that are the neighborhood index cells.}

\item{nhoodExpression}{A matrix of gene X neighbourhood expression.}

\item{.k}{An integer value. The same value used to build the k-NN graph if
already computed.}
}
\value{
a Milo object
}
\description{
The Milo class extends the SingleCellExperiment class and is designed to
work with neighbourhoods of cells. Therefore, it inherits from the
\linkS4class{SingleCellExperiment} class and follows the same usage
conventions. There is additional support for cell-to-cell distances
via distance, and the KNN-graph used to define the neighbourhoods.
}
\details{
In this class the underlying structure is the gene/feature X cell expression
data. The additional slots provide a link between these single cells and
the neighbourhood representation. This can be further extended by the use
of an abstracted graph for visualisation that preserves the structure of the
single-cell KNN-graph

A Milo object can also be constructed by inputting a feature X cell gene
expression matrix. In this case it simply constructs a SingleCellExperiment
and fills the relevant slots, such as reducedDims.
}
\examples{

library(SingleCellExperiment)
ux <- matrix(rpois(12000, 5), ncol=200)
vx <- log2(ux + 1)
pca <- prcomp(t(vx))

sce <- SingleCellExperiment(assays=list(counts=ux, logcounts=vx),
                            reducedDims=SimpleList(PCA=pca$x))

milo <- Milo(sce)
milo

}
\author{
Mike Morgan
}
