% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_plots.R
\name{plot_sample_heatmap}
\alias{plot_sample_heatmap}
\title{Sample heatmap}
\usage{
plot_sample_heatmap(
  object,
  all_features = FALSE,
  dist_method = "euclidean",
  clust_method = "ward.D2",
  center = TRUE,
  scale = "uv",
  group_bar = TRUE,
  group = NULL,
  title = "Heatmap of distances between samples",
  subtitle = NULL,
  fill_scale_con = getOption("notame.fill_scale_con"),
  fill_scale_dis = getOption("notame.fill_scale_dis"),
  assay.type = NULL
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{all_features}{logical, should all features be used? If FALSE (the 
default), flagged features are removed before visualization.}

\item{dist_method}{distance method used in clustering as in
\code{\link[stats]{dist}}}

\item{clust_method}{method used in clustering as in
\code{\link[stats]{hclust}}}

\item{center}{logical, should the data be centered?}

\item{scale}{scaling used, as in 
\code{\link[pcaMethods]{prep}}. Default is "uv" for unit variance}

\item{group_bar}{logical, should a bar showing the groups be drawn under the 
heat map?}

\item{group}{character, name of the column used for coloring the group bar}

\item{title}{The plot title}

\item{subtitle}{The plot subtitle}

\item{fill_scale_con}{Continuous fill scale for the heatmap as returned by a 
ggplot function}

\item{fill_scale_dis}{Discrete fill scale for the group bar as returned by a 
ggplot function}

\item{assay.type}{character, assay to be used in case of multiple assays}
}
\value{
A ggplot object. If \code{group_bar} is \code{TRUE}, the plot will 
consist of multiple parts and is harder to modify.
}
\description{
Draws a heatmap of the distances between the samples of an experiment,
the samples are ordered by hierarchical clustering.
}
\examples{
data(toy_notame_set, package = "notame")
plot_sample_heatmap(toy_notame_set, group = "Group")

}
\seealso{
\code{\link{dist}} \code{\link{hclust}}
}
