% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_funs.R
\name{rowshift}
\alias{rowshift}
\title{Row-wise normalization of expression matrix with or without reference sample}
\usage{
rowshift(x, batch, ref = NULL, useMean = FALSE)
}
\arguments{
\item{x}{an expression matrix where rows are features, e.g. genes, proteins 
and columns are samples. The values in the matrix are usually log transformed.}

\item{batch}{a factor or vector has the same length as \code{ncol(x)} to indicate
the batch assignment of samples.}

\item{ref}{a logical vector has the same length as \code{ncol(x)} to indicated which
columns are the common references among batches. If it is NULL (by default), 
the mean of all channels will be used as batch reference. When NA present in the 
reference channels, the mean values will be used in correction.}

\item{useMean}{logical; whether to use means of batches, usually set to TRUE 
when no reference available}
}
\value{
a matrix (hopefully without/with less batch effect)
}
\description{
Row-wise normalization of expression matrix with or without reference sample
}
\examples{
e1 <- matrix(rnorm(5000), 500, 10)
e1[, 6:10] <- e1[, 6:10] + 3
boxplot(e1)
f <- rep(c("a", "b"), each = 5)
e2 <- rowshift(x = e1, batch = f)
boxplot(e2)
}
