% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{gatingTemplate-class}
\alias{gatingTemplate-class}
\alias{gatingTemplate}
\alias{gatingTemplate,character-method}
\alias{gatingTemplate,data.table-method}
\title{a class storing the gating method and population information in a graphNEL object}
\usage{
gatingTemplate(x, ...)

\S4method{gatingTemplate}{character}(
  x,
  name = "default",
  strict = TRUE,
  strip_extra_quotes = FALSE,
  ...
)

\S4method{gatingTemplate}{data.table}(
  x,
  name = "default",
  strict = TRUE,
  strip_extra_quotes = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{character} csv file name or a \code{data.table}}

\item{...}{other arguments passed to \code{data.table::fread}}

\item{name}{\code{character} the label of the gating template}

\item{strict}{\code{logical} whether to perform validity check(special characters) on the alias column. By default it is(and should be) turned on for the regular template parsing. 
But sometime it is useful to turned it off to bypass the check for the dummy nodes(e.g. the csv template generated by 'gh_generate_template'  with some existing boolean gates that has '!' or ':' symbol).}

\item{strip_extra_quotes}{\code{logical} Extra quotes are added to strings by fread. This causes problems with parsing R strings to expressions in some cases. Default FALSE for usual behaviour. TRUE should be passed if parsing gating_args fails.}
}
\description{
Each cell population is stored in graph node and is connected with its parent population 
or its reference node for boolGate or refGate.

It parses the csv file that specifies the gating scheme for a particular staining pannel.
}
\details{
This csv must have the following columns:

'alias': a name used label the cell population, the path composed by the alias and its precedent nodes (e.g. /root/A/B/alias) has to be uniquely identifiable.
         So alias can not contain '/' character, which is reserved as path delimiter.
 
'pop': population patterns of '+/-` or '+/-+/-', which tells the algorithm which side (postive or negative) of 1d gate or which quadrant of 2d gate to be kept.
                        
'parent': the parent population alias, its path has to be uniquely identifiable.
 
'dims': characters seperated by comma specifying the dimensions(1d or 2d) used for gating. 
It can be either channel name or stained marker name (or the substrings of channel/marker names as long as they are uniquely identifiable.).
 
'gating_method': the name of the gating function (e.g. 'flowClust'). It is invoked by a wrapper function that has the identical function name prefixed with a dot.(e.g. '.flowClust')
    
'gating_args': the named arguments passed to gating function (Note that double quotes are often used as text delimiter by some csv editors. So try to use single quote instead if needed.)
 
'collapseDataForGating': When TRUE, data is collapsed (within groups if 'groupBy' specified) before gating and the gate is replicated across collapsed samples.
 When set FALSE (or blank),then 'groupBy' argument is only used by 'preprocessing' and ignored by gating.
   
'groupBy': If given, samples are split into groups by the unique combinations of study variable (i.e. column names of pData,e.g."PTID:VISITNO").
 when split is numeric, then samples are grouped by every N samples 

'preprocessing_method': the name of the preprocessing function(e.g. 'prior_flowclust'). It is invoked by a wrapper function that has the identical function name prefixed with a dot.(e.g. '.prior_flowclust')
 the preprocessing results are then passed to gating wrapper function through 'pps_res' argument.
      
'preprocessing_args': the named arguments passed to preprocessing function.
}
\examples{
\dontrun{ 
  gt <- gatingTemplate(system.file("extdata/gating_template/tcell.csv",package = "openCyto"))
  plot(gt)
}

}
