% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_pop.R
\name{gs_remove_gating_method}
\alias{gs_remove_gating_method}
\alias{remove_pop}
\title{Reverse the action of gating methods applied via \code{gs_add_gating_method}}
\usage{
gs_remove_gating_method(gs)
}
\arguments{
\item{gs}{The \code{GatingSet} or \code{GatingSetList} for which the most recent
\code{gs_add_gating_method} call should be reversed.}
}
\description{
This function provides an easy way to remove the gates and nodes created by the most
recent call to \code{\link{gs_add_gating_method}} on the specified \code{GatingSet} or \code{GatingSetList},
with a separate history being maintained for each such object. \code{gs_remove_gating_method} allows 
for repeated use, effectively serving as a multi-level undo function for \code{gs_add_gating_method}.
}
\examples{
\dontrun{
 # add quad gates 
 gs_add_gating_method(gs, gating_method = "mindensity", dims = "CCR7,CD45RA", parent = "cd4-cd8+", pop = "CCR7+/-CD45RA+/-")
 # Remove the gates and nodes resulting from that gs_add_gating_method call
 gs_remove_gating_method(gs)
} 
}
\seealso{
\code{\link{gs_add_gating_method}} \code{\link{gs_add_gating_method_init}}
}
