% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gating-functions.R
\name{gate_flowclust_1d}
\alias{gate_flowclust_1d}
\alias{gate_flowClust_1d}
\alias{flowClust.1d}
\title{Applies flowClust to 1 feature to determine a cutpoint between the minimum
cluster and all other clusters.}
\usage{
gate_flowclust_1d(
  fr,
  params,
  filterId = "",
  K = NULL,
  trans = 0,
  min.count = -1,
  max.count = -1,
  nstart = 1,
  prior = NULL,
  criterion = c("BIC", "ICL"),
  cutpoint_method = c("boundary", "min_density", "quantile", "posterior_mean",
    "prior_density"),
  neg_cluster = 1,
  cutpoint_min = NULL,
  cutpoint_max = NULL,
  min = NULL,
  max = NULL,
  quantile = 0.99,
  quantile_interval = c(0, 10),
  plot = FALSE,
  debug = FALSE,
  ...
)
}
\arguments{
\item{fr}{a \code{flowFrame} object}

\item{params}{\code{character} channel to be gated on}

\item{filterId}{A \code{character} string that identifies the filter created.}

\item{K}{the number of clusters to find}

\item{trans, min.count, max.count, nstart}{some flowClust parameters. see \code{\link{flowClust}}}

\item{prior}{list of prior parameters for the Bayesian
\code{\link{flowClust}}. If \code{NULL}, no prior is used.}

\item{criterion}{a character string stating the criterion used to choose the
best model. May take either "BIC" or "ICL". This argument is only relevant
when \code{K} is \code{NULL} or if \code{length(K) > 1}. The value selected
is passed to \code{\link{flowClust}}.}

\item{cutpoint_method}{How should the cutpoint be chosen from the fitted
\code{\link{flowClust}} model? See Details.}

\item{neg_cluster}{integer. The index of the negative cluster. The cutpoint
is computed between clusters \code{neg_cluster} and \code{neg_cluster + 1}.}

\item{cutpoint_min}{numeric value that sets a minimum thresold for the
cutpoint. If a value is provided, any cutpoint below this value will be set
to the given minimum value. If \code{NULL} (default), there is no minimum
cutpoint value.}

\item{cutpoint_max}{numeric value that sets a maximum thresold for the
cutpoint. If a value is provided, any cutpoint above this value will be set
to the given maximum value. If \code{NULL} (default), there is no maximum
cutpoint value.}

\item{min}{a numeric value that sets the lower bound for data filtering. If
\code{NULL} (default), no truncation is applied.}

\item{max}{a numeric value that sets the upper bound for data filtering. If
\code{NULL} (default), no truncation is applied.}

\item{quantile}{the quantile for which we will find the cutpoint using
the quantile \code{cutpoint_method}. If the \code{cutpoint_method} is not set
to \code{quantile}, this argument is ignored.}

\item{quantile_interval}{a vector of length 2 containing the end-points of
the interval of values to find the quantile cutpoint. If the
\code{cutpoint_method} is not set to \code{quantile}, this argument is
ignored.}

\item{plot}{logical value indicating that the fitted \code{\link{flowClust}}
model should be plotted along with the cutpoint}

\item{debug}{\code{logical} indicating whether to carry the prior and posterious with the gate
for debugging purpose. Default is FALSE.}

\item{...}{additional arguments that are passed to \code{\link{flowClust}}}
}
\value{
a \code{rectangleGate} object consisting of all values beyond the
cutpoint calculated
}
\description{
We cluster the observations in \code{fr} into \code{K} clusters.
}
\details{
By default, the cutpoint is chosen to be the boundary of the first two
clusters. That is, between the first two cluster centroids, we find the
midpoint between the largest observation from the first cluster and the
smallest observations from the second cluster. Alternatively, if the
\code{cutpoint_method} is \code{min_density}, then the cutpoint is the point
at which the density between the first and second smallest cluster centroids
is minimum.
}
\examples{
\dontrun{
 gate <- gate_flowclust_1d(fr, params = "APC-A", K =2) # fr is a flowFrame
}
}
